/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;

class GithubActionsInfo
extends CIProviderInfo {
    public static final String GHACTIONS = "GITHUB_ACTION";
    public static final String GHACTIONS_PROVIDER_NAME = "github";
    public static final String GHACTIONS_PIPELINE_ID = "GITHUB_RUN_ID";
    public static final String GHACTIONS_PIPELINE_NAME = "GITHUB_WORKFLOW";
    public static final String GHACTIONS_PIPELINE_NUMBER = "GITHUB_RUN_NUMBER";
    public static final String GHACTIONS_WORKSPACE_PATH = "GITHUB_WORKSPACE";
    public static final String GHACTIONS_REPOSITORY = "GITHUB_REPOSITORY";
    public static final String GHACTIONS_SHA = "GITHUB_SHA";
    public static final String GHACTIONS_HEAD_REF = "GITHUB_HEAD_REF";
    public static final String GHACTIONS_REF = "GITHUB_REF";

    GithubActionsInfo() {
        String repo = System.getenv(GHACTIONS_REPOSITORY);
        String commit = System.getenv(GHACTIONS_SHA);
        String url = this.buildPipelineUrl(repo, commit);
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(GHACTIONS_PROVIDER_NAME).withCiPipelineId(System.getenv(GHACTIONS_PIPELINE_ID)).withCiPipelineName(System.getenv(GHACTIONS_PIPELINE_NAME)).withCiPipelineNumber(System.getenv(GHACTIONS_PIPELINE_NUMBER)).withCiPipelineUrl(url).withCiJorUrl(url).withCiWorkspacePath(this.expandTilde(System.getenv(GHACTIONS_WORKSPACE_PATH))).withGitRepositoryUrl(this.buildGitRepositoryUrl(repo)).withGitCommit(commit).withGitBranch(this.buildGitBranch()).withGitTag(this.buildGitTag()).build();
    }

    private String buildGitTag() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitBranch() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && !gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitRepositoryUrl(String repo) {
        return String.format("https://github.com/%s.git", repo);
    }

    private String buildPipelineUrl(String repo, String commit) {
        return String.format("https://github.com/%s/commit/%s/checks", repo, commit);
    }
}

