/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.rmi;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

public class ContextPayload {
    private static final Logger log = LoggerFactory.getLogger(ContextPayload.class);
    private final Map<String, String> context;
    public static final InjectAdapter SETTER = new InjectAdapter();

    public ContextPayload() {
        this.context = new HashMap<String, String>();
    }

    public ContextPayload(Map<String, String> context) {
        this.context = context;
    }

    public static ContextPayload from(AgentSpan span) {
        ContextPayload payload = new ContextPayload();
        AgentTracer.propagate().inject(span, payload, SETTER);
        return payload;
    }

    public static ContextPayload read(ObjectInput oi) throws IOException {
        try {
            Object object = oi.readObject();
            if (object instanceof Map) {
                return new ContextPayload((Map)object);
            }
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            log.debug("Error reading object", ex);
        }
        return null;
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeObject(this.context);
    }

    public Map<String, String> getContext() {
        return this.context;
    }

    public static class InjectAdapter
    implements AgentPropagation.Setter<ContextPayload> {
        @Override
        public void set(ContextPayload carrier, String key, String value) {
            carrier.getContext().put(key, value);
        }
    }
}

