/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.ddlogger;

import datadog.slf4j.Marker;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LogLevelSwitcher;
import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.LoggerHelperFactory;
import java.util.Map;

public final class SwitchableLogLevelFactory
extends LoggerHelperFactory
implements LogLevelSwitcher {
    private final LoggerHelperFactory delegate;
    private volatile LogLevel override = null;

    public SwitchableLogLevelFactory(LoggerHelperFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public void switchLevel(LogLevel level) {
        this.override = level;
    }

    @Override
    public void restore() {
        this.override = null;
    }

    @Override
    public LoggerHelper loggerHelperForName(String name) {
        return new Helper(this.delegate.loggerHelperForName(name));
    }

    @Override
    public Map<String, Object> getSettingsDescription() {
        return this.delegate.getSettingsDescription();
    }

    final class Helper
    extends LoggerHelper {
        private final LoggerHelper delegate;

        private Helper(LoggerHelper delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean enabled(LogLevel level, Marker marker) {
            if (this.delegate.enabled(level, marker)) {
                return true;
            }
            LogLevel levelOverride = SwitchableLogLevelFactory.this.override;
            return null != levelOverride && level.isEnabled(levelOverride);
        }

        @Override
        public void log(LogLevel level, String message, Throwable t) {
            this.delegate.log(level, message, t);
        }
    }
}

