/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.simplelogger;

import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.LoggerHelperFactory;
import datadog.trace.logging.simplelogger.SLCompatHelper;
import datadog.trace.logging.simplelogger.SLCompatSettings;
import java.util.Map;
import java.util.Properties;

public final class SLCompatFactory
extends LoggerHelperFactory {
    static final long START_TIME = System.currentTimeMillis();
    private final Properties properties;
    private volatile SLCompatSettings lazySettings;

    private static Properties getProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException e) {
            return new Properties();
        }
    }

    public SLCompatFactory() {
        this(SLCompatFactory.getProperties());
    }

    public SLCompatFactory(Properties properties) {
        this(properties, null);
    }

    public SLCompatFactory(Properties properties, SLCompatSettings settings) {
        this.properties = properties;
        this.lazySettings = settings;
    }

    private SLCompatSettings getSettings() {
        SLCompatSettings settings = this.lazySettings;
        while (settings == null) {
            try {
                settings = this.lazySettings = new SLCompatSettings(this.properties);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return settings;
    }

    @Override
    public LoggerHelper loggerHelperForName(String name) {
        SLCompatSettings settings = this.getSettings();
        return new SLCompatHelper(name, settings);
    }

    @Override
    public Map<String, Object> getSettingsDescription() {
        return this.getSettings().getSettingsDescription();
    }
}

