/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.junit.remote;

import com.datastax.junit.remote.Filter;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;

public class FilterAdapter
extends org.junit.runner.manipulation.Filter {
    private final Filter delegate;
    private final Map<Description, Boolean> shouldRunCache = new HashMap<Description, Boolean>();

    public FilterAdapter(Filter delegate) {
        this.delegate = delegate;
    }

    public void apply(Object child) throws NoTestsRemainException {
        if (!(child instanceof Filterable)) {
            return;
        }
        Filterable filterable = (Filterable)child;
        filterable.filter((org.junit.runner.manipulation.Filter)this);
    }

    public org.junit.runner.manipulation.Filter intersect(final org.junit.runner.manipulation.Filter second) {
        if (second == this || second == ALL) {
            return this;
        }
        final FilterAdapter first = this;
        return new org.junit.runner.manipulation.Filter(){

            public boolean shouldRun(Description description) {
                return first.shouldRun(description) && second.shouldRun(description);
            }

            public String describe() {
                return first.describe() + " and " + second.describe();
            }
        };
    }

    public boolean shouldRun(Description description) {
        try {
            Boolean result = this.shouldRunCache.get(description);
            if (result == null) {
                result = this.delegate.shouldRun(description);
                this.shouldRunCache.put(description, result);
            }
            return result;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public String describe() {
        try {
            return this.delegate.describe();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }
}

