/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.junit.remote;

import com.datastax.junit.remote.RemoteFilter;
import com.datastax.junit.remote.RunNotifierFascade;
import com.datastax.junit.remote.Runner;
import com.datastax.junit.remote.RunnerFactory;
import com.datastax.junit.remote.UnclosableOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.SimpleRemoteOutputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.rmi.Naming;
import java.rmi.RemoteException;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unitils.util.AnnotationUtils;

public class Remote
extends org.junit.runner.Runner
implements Filterable {
    private static final Logger log = LoggerFactory.getLogger(Remote.class);
    private Runner delegate;
    protected String endpoint;
    protected Class<? extends org.junit.runner.Runner> remoteRunnerClass;
    protected Class<?> clazz;

    public Remote(Class<?> clazz) throws InitializationError {
        this.clazz = clazz;
    }

    public void setup() {
    }

    public void teardown() {
    }

    protected void init() {
        RunWith runWith = (RunWith)AnnotationUtils.getClassLevelAnnotation(RunWith.class, this.clazz);
        this.remoteRunnerClass = runWith != null ? runWith.value() : BlockJUnit4ClassRunner.class;
        Host host = (Host)AnnotationUtils.getClassLevelAnnotation(Host.class, this.clazz);
        this.endpoint = host != null ? String.format("//{}:{}/{})", host.name(), host.port(), "remoteRunnerFactory") : "//localhost:4567/remoteRunnerFactory";
        this.setup();
    }

    public Description getDescription() {
        this.ensureDelegate();
        try {
            return this.delegate.getDescription();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void run(RunNotifier notifier) {
        this.ensureDelegate();
        try {
            SimpleRemoteOutputStream out = new SimpleRemoteOutputStream((OutputStream)new UnclosableOutputStream(System.out));
            SimpleRemoteOutputStream err = new SimpleRemoteOutputStream((OutputStream)new UnclosableOutputStream(System.err));
            this.delegate.run(new RunNotifierFascade(notifier), (RemoteOutputStream)out, (RemoteOutputStream)err);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.teardown();
        }
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        this.ensureDelegate();
        try {
            this.delegate.filter(new RemoteFilter(filter));
        }
        catch (RemoteException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof RemoteException && cause.getMessage().startsWith("notestsremain")) {
                throw (NoTestsRemainException)cause.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    private void ensureDelegate() {
        if (this.delegate == null) {
            this.init();
            try {
                RunnerFactory runnerFactory = (RunnerFactory)Naming.lookup(this.endpoint);
                this.delegate = runnerFactory.create(this.remoteRunnerClass.getName(), this.clazz.getName());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RunWith {
        public Class<? extends org.junit.runner.Runner> value() default BlockJUnit4ClassRunner.class;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Host {
        public String name() default "localhost";

        public int port() default 4567;
    }
}

