/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.junit.remote;

import com.datastax.junit.remote.DefaultRunnerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

public class RemoteTestServer {
    public static final int DEFAULT_PORT = 4567;
    public static final String NAME = "remoteRunnerFactory";
    private static final Logger log = LoggerFactory.getLogger(RemoteTestServer.class);
    private final int port;
    private InetAddress bindAddrees;
    private Registry registry;

    public RemoteTestServer(int port) throws Exception {
        this.port = port;
    }

    public RemoteTestServer() throws Exception {
        this(4567);
    }

    public RemoteTestServer(InetSocketAddress socketAddress) throws Exception {
        this(socketAddress.getPort());
        this.bindAddrees = socketAddress.getAddress();
    }

    public void start() throws Exception {
        if (this.bindAddrees == null) {
            this.registry = LocateRegistry.createRegistry(this.port);
        } else {
            SocketFactory socketFactory = new SocketFactory(this.bindAddrees);
            this.registry = LocateRegistry.createRegistry(this.port, (RMIClientSocketFactory)((Object)socketFactory), (RMIServerSocketFactory)((Object)socketFactory));
        }
        DefaultRunnerFactory factory = new DefaultRunnerFactory();
        this.registry.rebind(NAME, factory);
        log.info("Remote Test Runner service started, the RMI service registry listening at {}:{}", this.bindAddrees == null ? "0.0.0.0" : this.bindAddrees, (Object)this.port);
    }

    public void stop() throws Exception {
        this.registry.unbind(NAME);
        UnicastRemoteObject.unexportObject(this.registry, true);
    }

    public static void main(String[] args) {
        try {
            new RemoteTestServer().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class SocketFactory
    extends RMIMasterSocketFactory {
        private final InetAddress bindAddress;

        public SocketFactory(InetAddress bindAddress) {
            this.bindAddress = bindAddress;
        }

        public ServerSocket createServerSocket(int port) throws IOException {
            return new ServerSocket(port, 50, this.bindAddress);
        }
    }
}

