/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.junit.remote;

import com.datastax.junit.remote.Filter;
import com.datastax.junit.remote.FilterAdapter;
import com.datastax.junit.remote.RunNotifier;
import com.datastax.junit.remote.Runner;
import com.healthmarketscience.rmiio.RemoteOutputStream;
import com.healthmarketscience.rmiio.RemoteOutputStreamClient;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class RunnerFascade
extends UnicastRemoteObject
implements Runner {
    private final org.junit.runner.Runner delegate;

    public RunnerFascade(org.junit.runner.Runner delegate) throws RemoteException {
        this.delegate = delegate;
    }

    @Override
    public Description getDescription() throws RemoteException {
        return this.delegate.getDescription();
    }

    @Override
    public int testCount() throws RemoteException {
        return this.delegate.testCount();
    }

    @Override
    public void run(RunNotifier remoteRunNotifier, RemoteOutputStream out, RemoteOutputStream err) throws RemoteException {
        RunNotifierAdapter adapter = new RunNotifierAdapter(remoteRunNotifier);
        org.junit.runner.notification.RunNotifier runNotifier = new org.junit.runner.notification.RunNotifier();
        runNotifier.addListener((RunListener)adapter);
        PrintStream stdOut = System.out;
        PrintStream stdErr = System.err;
        try (PrintStream pout = new PrintStream(RemoteOutputStreamClient.wrap((RemoteOutputStream)out), true);
             PrintStream perr = new PrintStream(RemoteOutputStreamClient.wrap((RemoteOutputStream)err), true);){
            System.setOut(pout);
            System.setErr(perr);
            this.delegate.run(runNotifier);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            System.setOut(stdOut);
            System.setErr(stdErr);
        }
    }

    @Override
    public void filter(Filter filter) throws RemoteException {
        if (this.delegate instanceof Filterable) {
            try {
                ((Filterable)this.delegate).filter((org.junit.runner.manipulation.Filter)new FilterAdapter(filter));
            }
            catch (NoTestsRemainException e) {
                throw new RemoteException("notestsremain", e);
            }
        }
    }

    private static class RunNotifierAdapter
    extends RunListener {
        private final RunNotifier delegate;

        public RunNotifierAdapter(RunNotifier delegate) {
            this.delegate = delegate;
        }

        public void testRunStarted(Description description) throws Exception {
            this.delegate.fireTestRunStarted(description);
        }

        public void testRunFinished(Result result) throws Exception {
            this.flushStreams();
            this.delegate.fireTestRunFinished(result);
        }

        public void testStarted(Description description) throws Exception {
            this.delegate.fireTestStarted(description);
        }

        public void testFinished(Description description) throws Exception {
            this.flushStreams();
            this.delegate.fireTestFinished(description);
        }

        public void testFailure(Failure failure) throws Exception {
            this.flushStreams();
            this.delegate.fireTestFailure(failure);
        }

        public void testAssumptionFailure(Failure failure) {
            try {
                this.flushStreams();
                this.delegate.fireTestAssumptionFailed(failure);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void testIgnored(Description description) throws Exception {
            this.flushStreams();
            this.delegate.fireTestIgnored(description);
        }

        private void flushStreams() throws Exception {
            System.out.flush();
            System.err.flush();
        }
    }
}

