/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.java.ImportSorter;
import com.diffplug.spotless.java.LibJavaPreconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ImportOrderStep {
    private ImportOrderStep() {
    }

    @Deprecated
    public static FormatterStep createFromOrder(List<String> importOrder) {
        importOrder = LibJavaPreconditions.requireElementsNonNull(new ArrayList<String>(importOrder));
        return ImportOrderStep.createFromOrderImpl(importOrder);
    }

    public static FormatterStep createFromOrder(String ... importOrder) {
        List<String> importOrderList = LibJavaPreconditions.requireElementsNonNull(Arrays.asList(importOrder));
        return ImportOrderStep.createFromOrderImpl(importOrderList);
    }

    public static FormatterStep createFromFile(File importsFile) {
        Objects.requireNonNull(importsFile);
        return ImportOrderStep.createFromOrderImpl(ImportOrderStep.getImportOrder(importsFile));
    }

    private static FormatterStep createFromOrderImpl(List<String> importOrder) {
        return FormatterStep.createLazy("importOrder", () -> new State(importOrder), State::toFormatter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getImportOrder(File importsFile) {
        try (Stream<String> lines = Files.lines(importsFile.toPath());){
            List list = lines.filter(line -> !line.startsWith("#")).map(ImportOrderStep::splitIntoIndexAndName).sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toCollection(ArrayList::new));
            return list;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map.Entry<Integer, String> splitIntoIndexAndName(String line) {
        String[] pieces = line.split("=");
        Integer index = Integer.valueOf(pieces[0]);
        String name = pieces.length == 2 ? pieces[1] : "";
        return new AbstractMap.SimpleImmutableEntry<Integer, String>(index, name);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<String> importOrder;

        State(List<String> importOrder) {
            this.importOrder = importOrder;
        }

        FormatterFunc toFormatter() {
            return raw -> new ImportSorter(this.importOrder).format((String)raw);
        }
    }
}

