/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.json.gson;

import com.diffplug.spotless.JarState;
import com.diffplug.spotless.json.gson.GsonWrapperBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class GsonBuilderWrapper
extends GsonWrapperBase {
    private final Constructor<?> constructor;
    private final Method serializeNullsMethod;
    private final Method disableHtmlEscapingMethod;
    private final Method createMethod;

    GsonBuilderWrapper(JarState jarState) {
        Class<?> clazz = this.loadClass(jarState.getClassLoader(), "com.google.gson.GsonBuilder");
        this.constructor = this.getConstructor(clazz, new Class[0]);
        this.serializeNullsMethod = this.getMethod(clazz, "serializeNulls", new Class[0]);
        this.disableHtmlEscapingMethod = this.getMethod(clazz, "disableHtmlEscaping", new Class[0]);
        this.createMethod = this.getMethod(clazz, "create", new Class[0]);
    }

    Object createGsonBuilder() {
        return this.newInstance(this.constructor, new Object[0]);
    }

    Object serializeNulls(Object gsonBuilder) {
        return this.invoke(this.serializeNullsMethod, gsonBuilder, new Object[0]);
    }

    Object disableHtmlEscaping(Object gsonBuilder) {
        return this.invoke(this.disableHtmlEscapingMethod, gsonBuilder, new Object[0]);
    }

    Object create(Object gsonBuilder) {
        return this.invoke(this.createMethod, gsonBuilder, new Object[0]);
    }
}

