/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.kotlin;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.kotlin.BadSemver;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class KtLintStep {
    private static final String DEFAULT_VERSION = "0.46.1";
    static final String NAME = "ktlint";
    static final String PACKAGE = "com.pinterest";
    static final String MAVEN_COORDINATE = "com.pinterest:ktlint:";

    private KtLintStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return KtLintStep.create(KtLintStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, false, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep create(String version, Provisioner provisioner, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, false, useExperimental, userData, editorConfigOverride);
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner) {
        return KtLintStep.create(version, provisioner, true, false, Collections.emptyMap(), Collections.emptyMap());
    }

    public static FormatterStep createForScript(String version, Provisioner provisioner, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        return KtLintStep.create(version, provisioner, true, useExperimental, userData, editorConfigOverride);
    }

    private static FormatterStep create(String version, Provisioner provisioner, boolean isScript, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverride) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(version, provisioner, isScript, useExperimental, userData, editorConfigOverride), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean isScript;
        final JarState jarState;
        private final boolean useExperimental;
        private final TreeMap<String, String> userData;
        private final TreeMap<String, Object> editorConfigOverride;

        State(String version, Provisioner provisioner, boolean isScript, boolean useExperimental, Map<String, String> userData, Map<String, Object> editorConfigOverride) throws IOException {
            if (BadSemver.version(version) < BadSemver.version(0, 46, 0)) {
                throw new IllegalStateException("KtLint versions < 0.46.0 not supported!");
            }
            this.useExperimental = useExperimental;
            this.userData = new TreeMap<String, String>(userData);
            this.editorConfigOverride = new TreeMap<String, Object>(editorConfigOverride);
            this.jarState = JarState.from(KtLintStep.MAVEN_COORDINATE + version, provisioner);
            this.isScript = isScript;
        }

        FormatterFunc createFormat() throws Exception {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.ktlint.KtlintFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(Boolean.TYPE, Boolean.TYPE, Map.class, Map.class);
            return (FormatterFunc.NeedsFile)constructor.newInstance(this.isScript, this.useExperimental, this.userData, this.editorConfigOverride);
        }
    }
}

