/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class Jsr223Step
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final JarState.Promised jarState;
    private final String engine;
    private final String script;

    private Jsr223Step(@Nullable JarState.Promised jarState, String engine, String script) {
        this.jarState = jarState;
        this.engine = engine;
        this.script = script;
    }

    public static FormatterStep create(String name, @Nullable String dependency, CharSequence engine, CharSequence script, Provisioner provisioner) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(engine, "engine");
        Objects.requireNonNull(script, "script");
        return FormatterStep.create(name, new Jsr223Step(dependency == null ? null : JarState.promise(() -> JarState.from(dependency, provisioner)), engine.toString(), script.toString()), Jsr223Step::equalityState, State::toFormatter);
    }

    private State equalityState() {
        return new State(this.jarState == null ? null : this.jarState.get(), this.engine, this.script);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Nullable
        private final JarState jarState;
        private final String engine;
        private final String script;

        State(@Nullable JarState jarState, CharSequence engine, CharSequence script) {
            this.jarState = jarState;
            this.engine = engine.toString();
            this.script = script.toString();
        }

        FormatterFunc toFormatter() {
            ScriptEngineManager scriptEngineManager = this.jarState == null ? new ScriptEngineManager(ClassLoader.getSystemClassLoader()) : new ScriptEngineManager(this.jarState.getClassLoader());
            ScriptEngine scriptEngine = scriptEngineManager.getEngineByName(this.engine);
            if (scriptEngine == null) {
                throw new IllegalArgumentException("Unknown script engine '" + this.engine + "'. Available engines: " + scriptEngineManager.getEngineFactories().stream().flatMap(f -> f.getNames().stream()).collect(Collectors.joining(", ")));
            }
            return raw -> {
                scriptEngine.put("source", raw);
                return (String)scriptEngine.eval(this.script);
            };
        }
    }
}

