/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class ImportSorterImpl {
    private static final String CATCH_ALL_SUBGROUP = "";
    private static final String STATIC_KEYWORD = "static ";
    private static final String STATIC_SYMBOL = "\\#";
    private static final String SUBGROUP_SEPARATOR = "|";
    private final List<ImportsGroup> importsGroups;
    private final Set<String> knownGroupings = new HashSet<String>();
    private final Map<String, List<String>> matchingImports = new HashMap<String, List<String>>();
    private final List<String> notMatching = new ArrayList<String>();
    private final Set<String> allImportOrderItems = new HashSet<String>();
    private final Comparator<String> ordering;

    static List<String> sort(List<String> imports, List<String> importsOrder, boolean wildcardsLast, boolean semanticSort, Set<String> treatAsPackage, Set<String> treatAsClass, String lineFormat) {
        ImportSorterImpl importsSorter = new ImportSorterImpl(importsOrder, wildcardsLast, semanticSort, treatAsPackage, treatAsClass);
        return importsSorter.sort(imports, lineFormat);
    }

    private List<String> sort(List<String> imports, String lineFormat) {
        this.filterMatchingImports(imports);
        this.mergeNotMatchingItems(false);
        this.mergeNotMatchingItems(true);
        List<String> sortedImported = this.mergeMatchingItems();
        return this.getResult(sortedImported, lineFormat);
    }

    private ImportSorterImpl(List<String> importOrder, boolean wildcardsLast, boolean semanticSort, Set<String> treatAsPackage, Set<String> treatAsClass) {
        this.importsGroups = importOrder.stream().filter(Objects::nonNull).map(order -> new ImportsGroup((String)order, this.knownGroupings)).collect(Collectors.toList());
        this.putStaticItemIfNotExists(this.importsGroups);
        this.putCatchAllGroupIfNotExists(this.importsGroups);
        this.ordering = semanticSort ? new SemanticOrderingComparator(wildcardsLast, treatAsPackage, treatAsClass) : new LexicographicalOrderingComparator(wildcardsLast);
        List subgroups = this.importsGroups.stream().map(ImportsGroup::getSubGroups).flatMap(Collection::stream).collect(Collectors.toList());
        this.allImportOrderItems.addAll(subgroups);
    }

    private void putStaticItemIfNotExists(List<ImportsGroup> importsGroups) {
        boolean catchAllSubGroupExist = importsGroups.stream().anyMatch(group -> group.getSubGroups().contains(STATIC_KEYWORD));
        if (catchAllSubGroupExist) {
            return;
        }
        int indexOfFirstStatic = 0;
        for (int i = 0; i < importsGroups.size(); ++i) {
            boolean subgroupMatch = importsGroups.get(i).getSubGroups().stream().anyMatch(subgroup -> subgroup.startsWith(STATIC_KEYWORD));
            if (!subgroupMatch) continue;
            indexOfFirstStatic = i;
        }
        importsGroups.add(indexOfFirstStatic, new ImportsGroup(STATIC_KEYWORD, this.knownGroupings));
    }

    private void putCatchAllGroupIfNotExists(List<ImportsGroup> importsGroups) {
        boolean catchAllSubGroupExist = importsGroups.stream().anyMatch(group -> group.getSubGroups().contains(CATCH_ALL_SUBGROUP));
        if (!catchAllSubGroupExist) {
            importsGroups.add(new ImportsGroup(CATCH_ALL_SUBGROUP, this.knownGroupings));
        }
    }

    private void filterMatchingImports(List<String> imports) {
        for (String anImport : imports) {
            String orderItem = this.getBestMatchingImportOrderItem(anImport);
            if (orderItem != null) {
                this.matchingImports.computeIfAbsent(orderItem, key -> new ArrayList());
                this.matchingImports.get(orderItem).add(anImport);
                continue;
            }
            this.notMatching.add(anImport);
        }
        this.notMatching.addAll(this.allImportOrderItems);
    }

    @Nullable
    private String getBestMatchingImportOrderItem(String anImport) {
        String matchingImport = null;
        for (String orderItem : this.allImportOrderItems) {
            if (!anImport.startsWith(orderItem)) continue;
            if (matchingImport == null) {
                matchingImport = orderItem;
                continue;
            }
            matchingImport = ImportSorterImpl.betterMatching(matchingImport, orderItem, anImport);
        }
        return matchingImport;
    }

    private void mergeNotMatchingItems(boolean staticItems) {
        for (String notMatchingItem : this.notMatching) {
            boolean isOrderItem;
            if (!ImportSorterImpl.matchesStatic(staticItems, notMatchingItem) || (isOrderItem = this.isOrderItem(notMatchingItem, staticItems))) continue;
            this.matchingImports.computeIfAbsent(CATCH_ALL_SUBGROUP, key -> new ArrayList());
            this.matchingImports.get(CATCH_ALL_SUBGROUP).add(notMatchingItem);
        }
    }

    private boolean isOrderItem(String notMatchingItem, boolean staticItems) {
        boolean contains = this.allImportOrderItems.contains(notMatchingItem);
        return contains && ImportSorterImpl.matchesStatic(staticItems, notMatchingItem);
    }

    private static boolean matchesStatic(boolean staticItems, String notMatchingItem) {
        boolean isStatic = notMatchingItem.startsWith(STATIC_KEYWORD);
        return isStatic && staticItems || !isStatic && !staticItems;
    }

    private List<String> mergeMatchingItems() {
        ArrayList<String> template = new ArrayList<String>();
        for (ImportsGroup group : this.importsGroups) {
            boolean groupIsNotEmpty = false;
            for (String subgroup : group.getSubGroups()) {
                List<String> strings = this.matchingImports.get(subgroup);
                if (strings == null || strings.isEmpty()) continue;
                groupIsNotEmpty = true;
                ArrayList<String> matchingItems = new ArrayList<String>(strings);
                this.sort(matchingItems);
                template.addAll(matchingItems);
            }
            if (!groupIsNotEmpty) continue;
            template.add("\n");
        }
        if (!template.isEmpty() && "\n".equals(template.get(template.size() - 1))) {
            template.remove(template.size() - 1);
        }
        return template;
    }

    private void sort(List<String> items) {
        items.sort(this.ordering);
    }

    private List<String> getResult(List<String> sortedImported, String lineFormat) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String s : sortedImported) {
            if ("\n".equals(s)) {
                strings.add(s);
                continue;
            }
            strings.add(lineFormat.formatted(s) + "\n");
        }
        return strings;
    }

    @Nullable
    private static String betterMatching(String order1, String order2, String anImport) {
        if (order1.equals(order2)) {
            throw new IllegalArgumentException("orders are same");
        }
        for (int i = 0; i < anImport.length() - 1; ++i) {
            if (order1.length() - 1 == i && order2.length() - 1 != i) {
                return order2;
            }
            if (order2.length() - 1 == i && order1.length() - 1 != i) {
                return order1;
            }
            char orderChar1 = order1.length() != 0 ? (char)order1.charAt(i) : (char)' ';
            char orderChar2 = order2.length() != 0 ? (char)order2.charAt(i) : (char)' ';
            char importChar = anImport.charAt(i);
            if (importChar == orderChar1 && importChar != orderChar2) {
                return order1;
            }
            if (importChar == orderChar1 || importChar != orderChar2) continue;
            return order2;
        }
        return null;
    }

    private static int compareWithWildcare(String string1, String string2, boolean wildcardsLast) {
        boolean string2IsWildcard;
        int string1WildcardIndex = string1.indexOf(42);
        int string2WildcardIndex = string2.indexOf(42);
        boolean string1IsWildcard = string1WildcardIndex >= 0;
        boolean bl = string2IsWildcard = string2WildcardIndex >= 0;
        if (string1IsWildcard == string2IsWildcard) {
            return string1.compareTo(string2);
        }
        int prefixLength = string1IsWildcard ? string1WildcardIndex : string2WildcardIndex;
        boolean samePrefix = string1.regionMatches(0, string2, 0, prefixLength);
        if (!samePrefix) {
            return string1.compareTo(string2);
        }
        return string1IsWildcard == wildcardsLast ? 1 : -1;
    }

    private static final class SemanticOrderingComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean wildcardsLast;
        private final Set<String> treatAsPackage;
        private final Set<String> treatAsClass;

        private SemanticOrderingComparator(boolean wildcardsLast, Set<String> treatAsPackage, Set<String> treatAsClass) {
            this.wildcardsLast = wildcardsLast;
            this.treatAsPackage = treatAsPackage;
            this.treatAsClass = treatAsClass;
        }

        @Override
        public int compare(String string1, String string2) {
            if (string1.startsWith(ImportSorterImpl.STATIC_KEYWORD)) {
                String[] split = this.splitFqcnAndMember(string1);
                String fqcn1 = split[0];
                String member1 = split[1];
                split = this.splitFqcnAndMember(string2);
                String fqcn2 = split[0];
                String member2 = split[1];
                int result = this.compareFullyQualifiedClassName(fqcn1, fqcn2);
                if (result != 0) {
                    return result;
                }
                return ImportSorterImpl.compareWithWildcare(member1, member2, this.wildcardsLast);
            }
            return this.compareFullyQualifiedClassName(string1, string2);
        }

        private int compareFullyQualifiedClassName(String fqcn1, String fqcn2) {
            String[] split = this.splitPackageAndClasses(fqcn1);
            String p1 = split[0];
            String c1 = split[1];
            split = this.splitPackageAndClasses(fqcn2);
            String p2 = split[0];
            String c2 = split[1];
            int result = p1.compareTo(p2);
            if (result != 0) {
                return result;
            }
            return ImportSorterImpl.compareWithWildcare(c1, c2, this.wildcardsLast);
        }

        private String[] splitFqcnAndMember(String importString) {
            String s = importString.substring(ImportSorterImpl.STATIC_KEYWORD.length()).trim();
            int dot = s.lastIndexOf(".");
            String fqcn = s.substring(0, dot);
            String member = s.substring(dot + 1);
            return new String[]{fqcn, member};
        }

        private String[] splitPackageAndClasses(String fqcn) {
            String packageNames = null;
            String classNames = null;
            int dot = fqcn.indexOf(46);
            while (dot > -1) {
                int nextDot = fqcn.indexOf(46, dot + 1);
                if (nextDot > -1) {
                    if (Character.isUpperCase(fqcn.charAt(dot + 1))) {
                        if (!this.treatAsPackage(fqcn.substring(0, nextDot))) {
                            packageNames = fqcn.substring(0, dot);
                            classNames = fqcn.substring(dot + 1);
                            break;
                        }
                    } else if (this.treatAsClass(fqcn.substring(0, nextDot))) {
                        packageNames = fqcn.substring(0, dot);
                        classNames = fqcn.substring(dot + 1);
                        break;
                    }
                }
                dot = nextDot;
            }
            if (packageNames == null) {
                int i = fqcn.lastIndexOf(".");
                packageNames = fqcn.substring(0, i);
                classNames = fqcn.substring(i + 1);
            }
            return new String[]{packageNames, classNames};
        }

        private boolean treatAsPackage(String prefix) {
            return this.treatAsPackage != null && this.treatAsPackage.contains(prefix);
        }

        private boolean treatAsClass(String prefix) {
            return this.treatAsClass != null && this.treatAsClass.contains(prefix);
        }
    }

    private static final class LexicographicalOrderingComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean wildcardsLast;

        private LexicographicalOrderingComparator(boolean wildcardsLast) {
            this.wildcardsLast = wildcardsLast;
        }

        @Override
        public int compare(String string1, String string2) {
            return ImportSorterImpl.compareWithWildcare(string1, string2, this.wildcardsLast);
        }
    }

    private static class ImportsGroup {
        private final List<String> subGroups;

        public ImportsGroup(String importOrder, Set<String> knownGroupings) {
            this.subGroups = Stream.of(importOrder.split("\\|", -1)).map(this::normalizeStatic).filter(group -> !knownGroupings.contains(group)).collect(Collectors.toList());
            knownGroupings.addAll(this.subGroups);
        }

        private String normalizeStatic(String subgroup) {
            if (subgroup.startsWith(ImportSorterImpl.STATIC_SYMBOL)) {
                return subgroup.replace(ImportSorterImpl.STATIC_SYMBOL, ImportSorterImpl.STATIC_KEYWORD);
            }
            return subgroup;
        }

        public List<String> getSubGroups() {
            return this.subGroups;
        }
    }
}

