/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.Jvm;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Unsafe;

final class ModuleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleHelper.class);
    private static final Map<String, String> REQUIRED_PACKAGES_TO_TEST_CLASSES = new HashMap<String, String>();
    private static boolean checkDone;

    private ModuleHelper() {
    }

    public static synchronized void doOpenInternalPackagesIfRequired() {
        if (Jvm.version() < 16 || checkDone) {
            return;
        }
        try {
            checkDone = true;
            List<String> unavailableRequiredPackages = ModuleHelper.unavailableRequiredPackages();
            if (!unavailableRequiredPackages.isEmpty()) {
                ModuleHelper.openPackages(unavailableRequiredPackages);
                List<String> failedToOpen = ModuleHelper.unavailableRequiredPackages();
                if (!failedToOpen.isEmpty()) {
                    StringBuilder message = new StringBuilder();
                    message.append("WARNING: Some required internal classes are unavailable. Please consider adding the following JVM arguments\n");
                    message.append("WARNING: ");
                    for (String name : failedToOpen) {
                        message.append("--add-opens jdk.compiler/%s=ALL-UNNAMED".formatted(name));
                    }
                    LOGGER.warn("{}", (Object)message);
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("WARNING: Failed to check for available JDK packages.", e);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static List<String> unavailableRequiredPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (Map.Entry<String, String> e : REQUIRED_PACKAGES_TO_TEST_CLASSES.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            try {
                Class<?> clazz = Class.forName(key + "." + value);
                if (clazz.isEnum()) {
                    clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    continue;
                }
                clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException ex) {
                packages.add(key);
            }
            catch (Exception exception) {}
        }
        return packages;
    }

    private static void openPackages(Collection<String> packagesToOpen) throws Throwable {
        Collection<?> modules = ModuleHelper.allModules();
        if (modules == null) {
            return;
        }
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        MethodHandle modifiers = lookup.findSetter(Method.class, "modifiers", Integer.TYPE);
        Method exportMethod = Class.forName("java.lang.Module").getDeclaredMethod("implAddOpens", String.class);
        modifiers.invokeExact(exportMethod, 1);
        for (Object module : modules) {
            Collection packages = (Collection)module.getClass().getMethod("getPackages", new Class[0]).invoke(module, new Object[0]);
            for (String name : packages) {
                if (!packagesToOpen.contains(name)) continue;
                exportMethod.invoke(module, name);
            }
        }
    }

    @Nullable
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static Collection<?> allModules() {
        try {
            Object boot = Class.forName("java.lang.ModuleLayer").getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            if (boot == null) {
                return null;
            }
            Object modules = boot.getClass().getMethod("modules", new Class[0]).invoke(boot, new Object[0]);
            return (Collection)modules;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    static {
        REQUIRED_PACKAGES_TO_TEST_CLASSES.putIfAbsent("com.sun.tools.javac.util", "Context");
        REQUIRED_PACKAGES_TO_TEST_CLASSES.putIfAbsent("com.sun.tools.javac.file", "CacheFSInfo");
        REQUIRED_PACKAGES_TO_TEST_CLASSES.putIfAbsent("com.sun.tools.javac.tree", "TreeTranslator");
        REQUIRED_PACKAGES_TO_TEST_CLASSES.putIfAbsent("com.sun.tools.javac.parser", "Tokens$TokenKind");
        REQUIRED_PACKAGES_TO_TEST_CLASSES.putIfAbsent("com.sun.tools.javac.api", "DiagnosticFormatter$PositionKind");
    }
}

