/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.annotations.VisibleForTesting;
import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.GitRatchetGradle;
import com.diffplug.gradle.spotless.IdeHook;
import com.diffplug.gradle.spotless.SerializableMisc;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.gradle.spotless.SpotlessTaskService;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.LintState;
import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@CacheableTask
public abstract class SpotlessTaskImpl
extends SpotlessTask {
    private transient Provider<SpotlessTaskService> taskServiceProvider;

    @Input
    @Optional
    abstract Property<IdeHook.State> getIdeHookState();

    @Override
    @Internal
    abstract DirectoryProperty getProjectDir();

    void init(Provider<SpotlessTaskService> service) {
        this.taskServiceProvider = service;
        SpotlessTaskService.usesServiceTolerateTestFailure(this, service);
        this.getTaskService().set(service);
        this.getProjectDir().set(this.getProject().getProjectDir());
    }

    @Internal
    Provider<SpotlessTaskService> getTaskServiceProvider() {
        return this.taskServiceProvider;
    }

    @Inject
    protected abstract FileSystemOperations getFs();

    @TaskAction
    public void performAction(InputChanges inputs) throws Exception {
        IdeHook.State ideHook = (IdeHook.State)((Object)this.getIdeHookState().getOrNull());
        if (ideHook != null && ideHook.path != null) {
            IdeHook.performHook(this, ideHook);
            return;
        }
        SpotlessTaskService taskService = (SpotlessTaskService)this.getTaskService().get();
        taskService.registerSourceAlreadyRan(this);
        if (this.target == null) {
            throw new GradleException("You must specify 'Iterable<File> target'");
        }
        if (!inputs.isIncremental()) {
            this.getLogger().info("Not incremental: removing prior outputs");
            this.getFs().delete(d -> d.delete(new Object[]{this.cleanDirectory}));
            this.getFs().delete(d -> d.delete(new Object[]{this.lintsDirectory}));
            Files.createDirectories(this.cleanDirectory.toPath(), new FileAttribute[0]);
            Files.createDirectories(this.lintsDirectory.toPath(), new FileAttribute[0]);
        }
        try (Formatter formatter = this.buildFormatter();){
            GitRatchetGradle ratchet = this.getRatchet();
            for (FileChange fileChange : inputs.getFileChanges(this.target)) {
                File input = fileChange.getFile();
                File projectDir = ((Directory)this.getProjectDir().get()).getAsFile();
                String relativePath = FormatExtension.relativize(projectDir, input);
                if (relativePath == null) {
                    throw new IllegalArgumentException(StringPrinter.buildString(printer -> {
                        printer.println("Spotless error! All target files must be within the project dir.");
                        printer.println("  project dir: " + projectDir.getAbsolutePath());
                        printer.println("       target: " + input.getAbsolutePath());
                    }));
                }
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    this.deletePreviousResults(this.cleanDirectory, relativePath);
                    this.deletePreviousResults(this.lintsDirectory, relativePath);
                    continue;
                }
                if (!input.isFile()) continue;
                this.processInputFile(ratchet, formatter, input, relativePath);
            }
        }
    }

    @VisibleForTesting
    void processInputFile(@Nullable GitRatchet ratchet, Formatter formatter, File input, String relativePath) throws IOException {
        LintState lintState;
        File cleanFile = new File(this.cleanDirectory, relativePath);
        File lintFile = new File(this.lintsDirectory, relativePath);
        this.getLogger().debug("Applying format to {} and writing to {}", (Object)input, (Object)cleanFile);
        if (ratchet != null && ratchet.isClean((Object)((Directory)this.getProjectDir().get()).getAsFile(), this.getRootTreeSha(), input)) {
            lintState = LintState.clean();
        } else {
            try {
                lintState = LintState.of((Formatter)formatter, (File)input).withRemovedSuppressions(formatter, relativePath, this.getLintSuppressions());
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Issue processing file: " + String.valueOf(input), e);
            }
        }
        if (lintState.getDirtyState().isClean()) {
            Files.deleteIfExists(cleanFile.toPath());
        } else if (lintState.getDirtyState().didNotConverge()) {
            this.getLogger().warn("Skipping '{}' because it does not converge.  Run {@code spotlessDiagnose} to understand why", (Object)relativePath);
        } else {
            Path parentDir = cleanFile.toPath().getParent();
            if (parentDir == null) {
                throw new IllegalStateException("Every file has a parent folder. But not: " + String.valueOf(cleanFile));
            }
            Files.createDirectories(parentDir, new FileAttribute[0]);
            Files.copy(input.toPath(), cleanFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            this.getLogger().info(String.format("Writing clean file: %s", cleanFile));
            lintState.getDirtyState().writeCanonicalTo(cleanFile);
        }
        if (!lintState.isHasLints()) {
            Files.deleteIfExists(lintFile.toPath());
        } else {
            LinkedHashMap lints = lintState.getLintsByStep(formatter);
            SerializableMisc.toFile(lints, lintFile);
        }
    }

    private void deletePreviousResults(File baseDir, String subpath) throws IOException {
        File output = new File(baseDir, subpath);
        if (output.isDirectory()) {
            this.getFs().delete(d -> d.delete(new Object[]{output}));
        } else {
            Files.deleteIfExists(output.toPath());
        }
    }
}

