/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsChannelFactory;
import com.eatthepath.pushy.apns.ApnsChannelPool;
import com.eatthepath.pushy.apns.ApnsChannelPoolMetricsListener;
import com.eatthepath.pushy.apns.ApnsClientMetricsListener;
import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.PushNotificationPromise;
import com.eatthepath.pushy.apns.PushNotificationResponse;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationFuture;
import com.eatthepath.pushy.apns.util.concurrent.PushNotificationResponseListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.SucceededFuture;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApnsClient {
    private final EventLoopGroup eventLoopGroup;
    private final boolean shouldShutDownEventLoopGroup;
    private final ApnsChannelPool channelPool;
    private final ApnsClientMetricsListener metricsListener;
    private final AtomicLong nextNotificationId = new AtomicLong(0L);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private static final IllegalStateException CLIENT_CLOSED_EXCEPTION = new IllegalStateException("Client has been closed and can no longer send push notifications.");
    private static final Logger log = LoggerFactory.getLogger(ApnsClient.class);

    protected ApnsClient(InetSocketAddress apnsServerAddress, SslContext sslContext, ApnsSigningKey signingKey, long tokenExpirationMillis, ProxyHandlerFactory proxyHandlerFactory, int connectTimeoutMillis, long idlePingIntervalMillis, long gracefulShutdownTimeoutMillis, int concurrentConnections, ApnsClientMetricsListener metricsListener, Http2FrameLogger frameLogger, EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.eventLoopGroup = new NioEventLoopGroup(1);
            this.shouldShutDownEventLoopGroup = true;
        }
        this.metricsListener = metricsListener != null ? metricsListener : new NoopApnsClientMetricsListener();
        ApnsChannelFactory channelFactory = new ApnsChannelFactory(sslContext, signingKey, tokenExpirationMillis, proxyHandlerFactory, connectTimeoutMillis, idlePingIntervalMillis, gracefulShutdownTimeoutMillis, frameLogger, apnsServerAddress, this.eventLoopGroup);
        ApnsChannelPoolMetricsListener channelPoolMetricsListener = new ApnsChannelPoolMetricsListener(){

            @Override
            public void handleConnectionAdded() {
                ApnsClient.this.metricsListener.handleConnectionAdded(ApnsClient.this);
            }

            @Override
            public void handleConnectionRemoved() {
                ApnsClient.this.metricsListener.handleConnectionRemoved(ApnsClient.this);
            }

            @Override
            public void handleConnectionCreationFailed() {
                ApnsClient.this.metricsListener.handleConnectionCreationFailed(ApnsClient.this);
            }
        };
        this.channelPool = new ApnsChannelPool(channelFactory, concurrentConnections, (OrderedEventExecutor)this.eventLoopGroup.next(), channelPoolMetricsListener);
    }

    public <T extends ApnsPushNotification> PushNotificationFuture<T, PushNotificationResponse<T>> sendNotification(T notification) {
        PushNotificationPromise responseFuture;
        if (!this.isClosed.get()) {
            final PushNotificationPromise responsePromise = new PushNotificationPromise((EventExecutor)this.eventLoopGroup.next(), notification);
            final long notificationId = this.nextNotificationId.getAndIncrement();
            this.channelPool.acquire().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> acquireFuture) throws Exception {
                    if (acquireFuture.isSuccess()) {
                        Channel channel = (Channel)acquireFuture.getNow();
                        channel.writeAndFlush((Object)responsePromise).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.isSuccess()) {
                                    ApnsClient.this.metricsListener.handleNotificationSent(ApnsClient.this, notificationId);
                                }
                            }
                        });
                        ApnsClient.this.channelPool.release(channel);
                    } else {
                        responsePromise.tryFailure(acquireFuture.cause());
                    }
                }
            });
            responsePromise.addListener(new PushNotificationResponseListener<T>(){

                public void operationComplete(PushNotificationFuture<T, PushNotificationResponse<T>> future) throws Exception {
                    if (future.isSuccess()) {
                        PushNotificationResponse response = (PushNotificationResponse)future.getNow();
                        if (response.isAccepted()) {
                            ApnsClient.this.metricsListener.handleNotificationAccepted(ApnsClient.this, notificationId);
                        } else {
                            ApnsClient.this.metricsListener.handleNotificationRejected(ApnsClient.this, notificationId);
                        }
                    } else {
                        ApnsClient.this.metricsListener.handleWriteFailure(ApnsClient.this, notificationId);
                    }
                }
            });
            responseFuture = responsePromise;
        } else {
            PushNotificationPromise failedPromise = new PushNotificationPromise((EventExecutor)GlobalEventExecutor.INSTANCE, notification);
            failedPromise.setFailure(CLIENT_CLOSED_EXCEPTION);
            responseFuture = failedPromise;
        }
        return responseFuture;
    }

    public Future<Void> close() {
        SucceededFuture closeFuture;
        log.info("Shutting down.");
        if (this.isClosed.compareAndSet(false, true)) {
            DefaultPromise closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
            this.channelPool.close().addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>((Promise)closePromise){
                final /* synthetic */ Promise val$closePromise;
                {
                    this.val$closePromise = promise;
                }

                public void operationComplete(Future<Void> closePoolFuture) throws Exception {
                    if (ApnsClient.this.shouldShutDownEventLoopGroup) {
                        ApnsClient.this.eventLoopGroup.shutdownGracefully().addListener(new GenericFutureListener(){

                            public void operationComplete(Future future) throws Exception {
                                val$closePromise.trySuccess(null);
                            }
                        });
                    } else {
                        this.val$closePromise.trySuccess(null);
                    }
                }
            });
            closeFuture = closePromise;
        } else {
            closeFuture = new SucceededFuture((EventExecutor)GlobalEventExecutor.INSTANCE, null);
        }
        return closeFuture;
    }

    private static class NoopApnsClientMetricsListener
    implements ApnsClientMetricsListener {
        private NoopApnsClientMetricsListener() {
        }

        @Override
        public void handleWriteFailure(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationSent(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationAccepted(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleNotificationRejected(ApnsClient apnsClient, long notificationId) {
        }

        @Override
        public void handleConnectionAdded(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionRemoved(ApnsClient apnsClient) {
        }

        @Override
        public void handleConnectionCreationFailed(ApnsClient apnsClient) {
        }
    }
}

