/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import java.util.UUID;

class BenchmarkApnsServerHandler
extends Http2ConnectionHandler
implements Http2FrameListener {
    private static final Http2Headers SUCCESS_HEADERS = (Http2Headers)new DefaultHttp2Headers().status((CharSequence)HttpResponseStatus.OK.codeAsText()).add((Object)new AsciiString((CharSequence)"apns-id"), (Object)new AsciiString((CharSequence)UUID.randomUUID().toString()));

    BenchmarkApnsServerHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
        super(decoder, encoder, initialSettings);
    }

    public int onDataRead(ChannelHandlerContext context, int streamId, ByteBuf data, int padding, boolean endOfStream) {
        if (endOfStream) {
            this.handleEndOfStream(context, streamId);
        }
        return data.readableBytes() + padding;
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int padding, boolean endOfStream) {
        if (endOfStream) {
            this.handleEndOfStream(context, streamId);
        }
    }

    private void handleEndOfStream(ChannelHandlerContext context, int streamId) {
        this.encoder().writeHeaders(context, streamId, SUCCESS_HEADERS, 0, true, context.channel().newPromise());
    }

    public void onHeadersRead(ChannelHandlerContext context, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) {
        this.onHeadersRead(context, streamId, headers, padding, endOfStream);
    }

    public void onPriorityRead(ChannelHandlerContext context, int streamId, int streamDependency, short weight, boolean exclusive) {
    }

    public void onRstStreamRead(ChannelHandlerContext context, int streamId, long errorCode) {
    }

    public void onSettingsAckRead(ChannelHandlerContext context) {
    }

    public void onSettingsRead(ChannelHandlerContext context, Http2Settings settings) {
    }

    public void onPingRead(ChannelHandlerContext context, long data) {
    }

    public void onPingAckRead(ChannelHandlerContext context, long data) {
    }

    public void onPushPromiseRead(ChannelHandlerContext context, int streamId, int promisedStreamId, Http2Headers headers, int padding) {
    }

    public void onGoAwayRead(ChannelHandlerContext context, int lastStreamId, long errorCode, ByteBuf debugData) {
    }

    public void onWindowUpdateRead(ChannelHandlerContext context, int streamId, int windowSizeIncrement) {
    }

    public void onUnknownFrame(ChannelHandlerContext context, byte frameType, int streamId, Http2Flags flags, ByteBuf payload) {
    }

    public static class BenchmarkApnsServerHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<BenchmarkApnsServerHandler, BenchmarkApnsServerHandlerBuilder> {
        public BenchmarkApnsServerHandlerBuilder initialSettings(Http2Settings initialSettings) {
            return (BenchmarkApnsServerHandlerBuilder)super.initialSettings(initialSettings);
        }

        public BenchmarkApnsServerHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) {
            BenchmarkApnsServerHandler handler = new BenchmarkApnsServerHandler(decoder, encoder, initialSettings);
            this.frameListener(handler);
            return handler;
        }

        public BenchmarkApnsServerHandler build() {
            return (BenchmarkApnsServerHandler)super.build();
        }
    }
}

