/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.impl.io;

import java.io.IOException;
import rp.org.apache.http.HttpException;
import rp.org.apache.http.HttpResponse;
import rp.org.apache.http.HttpResponseFactory;
import rp.org.apache.http.NoHttpResponseException;
import rp.org.apache.http.ParseException;
import rp.org.apache.http.StatusLine;
import rp.org.apache.http.config.MessageConstraints;
import rp.org.apache.http.impl.DefaultHttpResponseFactory;
import rp.org.apache.http.impl.io.AbstractMessageParser;
import rp.org.apache.http.io.SessionInputBuffer;
import rp.org.apache.http.message.LineParser;
import rp.org.apache.http.message.ParserCursor;
import rp.org.apache.http.params.HttpParams;
import rp.org.apache.http.util.Args;
import rp.org.apache.http.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

