/*
 * Decompiled with CFR 0.152.
 */
package rp.org.apache.http.protocol;

import java.io.IOException;
import rp.org.apache.http.HttpException;
import rp.org.apache.http.HttpRequest;
import rp.org.apache.http.HttpRequestInterceptor;
import rp.org.apache.http.annotation.Contract;
import rp.org.apache.http.annotation.ThreadingBehavior;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

