/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif;

import be.teletask.onvif.OnvifXMLBuilder;
import be.teletask.onvif.listeners.OnvifResponseListener;
import be.teletask.onvif.models.OnvifConfiguration;
import be.teletask.onvif.models.OnvifDevice;
import be.teletask.onvif.models.OnvifMediaProfile;
import be.teletask.onvif.models.OnvifPreset;
import be.teletask.onvif.models.OnvifServices;
import be.teletask.onvif.parsers.GetConfigurationsParser;
import be.teletask.onvif.parsers.GetDeviceInformationParser;
import be.teletask.onvif.parsers.GetMediaProfilesParser;
import be.teletask.onvif.parsers.GetMediaStreamParser;
import be.teletask.onvif.parsers.GetPresetsParser;
import be.teletask.onvif.parsers.GetServicesParser;
import be.teletask.onvif.parsers.GetSnapshotUriParser;
import be.teletask.onvif.parsers.GetStatusParser;
import be.teletask.onvif.parsers.SetPresetParser;
import be.teletask.onvif.requests.GetConfigurationsRequest;
import be.teletask.onvif.requests.GetDeviceInformationRequest;
import be.teletask.onvif.requests.GetMediaProfilesRequest;
import be.teletask.onvif.requests.GetMediaStreamRequest;
import be.teletask.onvif.requests.GetPresetsRequest;
import be.teletask.onvif.requests.GetServicesRequest;
import be.teletask.onvif.requests.GetSnapshotUriRequest;
import be.teletask.onvif.requests.GetStatusRequest;
import be.teletask.onvif.requests.OnvifRequest;
import be.teletask.onvif.requests.SetPresetRequest;
import be.teletask.onvif.responses.OnvifResponse;
import com.burgstaller.okhttp.AuthenticationCacheInterceptor;
import com.burgstaller.okhttp.CachingAuthenticatorDecorator;
import com.burgstaller.okhttp.digest.Credentials;
import com.burgstaller.okhttp.digest.DigestAuthenticator;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class OnvifExecutor {
    public static final String TAG = OnvifExecutor.class.getSimpleName();
    private OkHttpClient client;
    private MediaType reqBodyType;
    private RequestBody reqBody;
    private Credentials credentials;
    private OnvifResponseListener onvifResponseListener;

    OnvifExecutor(OnvifResponseListener onvifResponseListener) {
        this.onvifResponseListener = onvifResponseListener;
        this.credentials = new Credentials("username", "password");
        DigestAuthenticator authenticator = new DigestAuthenticator(this.credentials);
        ConcurrentHashMap authCache = new ConcurrentHashMap();
        this.client = new OkHttpClient.Builder().connectTimeout(10000L, TimeUnit.SECONDS).writeTimeout(100L, TimeUnit.SECONDS).readTimeout(10000L, TimeUnit.SECONDS).authenticator((Authenticator)new CachingAuthenticatorDecorator((Authenticator)authenticator, authCache)).addInterceptor((Interceptor)new AuthenticationCacheInterceptor(authCache)).build();
        this.reqBodyType = MediaType.parse((String)"application/soap+xml; charset=utf-8;");
    }

    void sendRequest(OnvifDevice device, OnvifRequest request) {
        if (this.onvifResponseListener == null) {
            return;
        }
        this.credentials.setUserName(device.getUsername());
        this.credentials.setPassword(device.getPassword());
        this.reqBody = RequestBody.create((String)(OnvifXMLBuilder.getSoapHeader() + request.getXml() + OnvifXMLBuilder.getEnvelopeEnd()), (MediaType)this.reqBodyType);
        this.performXmlRequest(device, request, this.buildOnvifRequest(device, request));
    }

    public void cleanUp() {
        if (this.onvifResponseListener != null) {
            this.onvifResponseListener = null;
        }
        this.client.dispatcher().cancelAll();
    }

    public void setOnvifResponseListener(OnvifResponseListener onvifResponseListener) {
        this.onvifResponseListener = onvifResponseListener;
    }

    private void performXmlRequest(final OnvifDevice device, final OnvifRequest request, Request xmlRequest) {
        if (xmlRequest == null) {
            return;
        }
        this.client.newCall(xmlRequest).enqueue(new Callback(){

            public void onResponse(Call call, Response xmlResponse) throws IOException {
                OnvifResponse response = new OnvifResponse(request);
                ResponseBody xmlBody = xmlResponse.body();
                if (xmlResponse.code() == 200 && xmlBody != null) {
                    response.setSuccess(true);
                    response.setXml(xmlBody.string());
                    OnvifExecutor.this.parseResponse(device, response);
                    return;
                }
                String errorMessage = "";
                if (xmlBody != null) {
                    errorMessage = xmlBody.string();
                }
                if (OnvifExecutor.this.onvifResponseListener != null) {
                    OnvifExecutor.this.onvifResponseListener.onError(device, xmlResponse.code(), errorMessage);
                }
            }

            public void onFailure(Call call, IOException e) {
                if (OnvifExecutor.this.onvifResponseListener != null) {
                    OnvifExecutor.this.onvifResponseListener.onError(device, -1, e.getMessage());
                }
            }
        });
    }

    private void parseResponse(OnvifDevice device, OnvifResponse response) {
        switch (response.request().getType()) {
            case GET_SERVICES: {
                OnvifServices path = new GetServicesParser().parse(response);
                device.setPath(path);
                ((GetServicesRequest)response.request()).getListener().onServicesReceived(device, path);
                break;
            }
            case GET_DEVICE_INFORMATION: {
                ((GetDeviceInformationRequest)response.request()).getListener().onDeviceInformationReceived(device, new GetDeviceInformationParser().parse(response));
                break;
            }
            case GET_MEDIA_PROFILES: {
                ((GetMediaProfilesRequest)response.request()).getListener().onMediaProfilesReceived(device, (List<OnvifMediaProfile>)new GetMediaProfilesParser().parse(response));
                break;
            }
            case GET_STREAM_URI: {
                GetMediaStreamRequest streamRequest = (GetMediaStreamRequest)response.request();
                streamRequest.getListener().onMediaStreamURIReceived(device, streamRequest.getMediaProfile(), new GetMediaStreamParser().parse(response));
                break;
            }
            case GET_SNAPSHOT_URI: {
                GetSnapshotUriRequest getSnapshotUriRequest = (GetSnapshotUriRequest)response.request();
                getSnapshotUriRequest.getListener().onSnapshotURIReceived(device, getSnapshotUriRequest.getMediaProfile(), new GetSnapshotUriParser().parse(response));
                break;
            }
            case GET_STATUS: {
                GetStatusRequest getStatusRequest = (GetStatusRequest)response.request();
                getStatusRequest.getListener().onStatusReceived(device, getStatusRequest.getMediaProfile(), new GetStatusParser().parse(response));
                break;
            }
            case GET_PRESETS: {
                GetPresetsRequest getPresetsRequest = (GetPresetsRequest)response.request();
                getPresetsRequest.getListener().onPresetsReceived(device, getPresetsRequest.getMediaProfile(), (List<OnvifPreset>)new GetPresetsParser().parse(response));
                break;
            }
            case SET_PRESET: {
                SetPresetRequest setPresetRequest = (SetPresetRequest)response.request();
                setPresetRequest.getListener().onPresetReceived(device, setPresetRequest.getMediaProfile(), new SetPresetParser().parse(response));
                break;
            }
            case GET_CONFIGURATIONS: {
                ((GetConfigurationsRequest)response.request()).getListener().onConfigurationsReceived(device, (List<OnvifConfiguration>)new GetConfigurationsParser().parse(response));
                break;
            }
            default: {
                this.onvifResponseListener.onResponse(device, response);
            }
        }
    }

    private Request buildOnvifRequest(OnvifDevice device, OnvifRequest request) {
        return new Request.Builder().url(this.getUrlForRequest(device, request)).addHeader("Content-Type", "text/xml; charset=utf-8").post(this.reqBody).build();
    }

    private String getUrlForRequest(OnvifDevice device, OnvifRequest request) {
        return device.getHostName() + this.getPathForRequest(device, request);
    }

    private String getPathForRequest(OnvifDevice device, OnvifRequest request) {
        switch (request.getType()) {
            case GET_SERVICES: 
            case GET_DEVICE_INFORMATION: {
                return device.getPath().getDevicePath();
            }
            case GET_MEDIA_PROFILES: 
            case GET_STREAM_URI: 
            case GET_SNAPSHOT_URI: {
                return device.getPath().getMediaPath();
            }
            case GET_STATUS: 
            case GET_PRESETS: 
            case SET_PRESET: 
            case GET_CONFIGURATIONS: 
            case ABSOLUTE_MOVE: 
            case GOTO_HOME_POSITION: 
            case GOTO_PRESET: 
            case REMOVE_PRESET: {
                return device.getPath().getPtzPath();
            }
        }
        return device.getPath().getServicesPath();
    }

    private String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            if (copy.body() != null) {
                copy.body().writeTo((BufferedSink)buffer);
            }
            return buffer.readUtf8();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

