/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.parsers;

import be.teletask.onvif.models.OnvifPreset;
import be.teletask.onvif.parsers.OnvifParser;
import be.teletask.onvif.responses.OnvifResponse;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class GetPresetsParser
extends OnvifParser<List<OnvifPreset>> {
    public static final String TAG = GetPresetsParser.class.getSimpleName();
    private static final String KEY_PRESET = "Preset";
    private static final String ATTR_TOKEN = "token";
    private static final String ATTR_NAME = "Name";
    private static final String KEY_POSITION = "PTZPosition";
    private static final String KEY_POSITION_PANTILT = "PanTilt";
    private static final String KEY_POSITION_ZOOM = "Zoom";

    @Override
    public List<OnvifPreset> parse(OnvifResponse response) {
        ArrayList<OnvifPreset> presets = new ArrayList<OnvifPreset>();
        try {
            this.getXpp().setInput((Reader)new StringReader(response.getXml()));
            this.eventType = this.getXpp().getEventType();
            while (this.eventType != 1) {
                OnvifPreset onvifPreset = new OnvifPreset();
                if (this.eventType == 2 && this.getXpp().getName().equals(KEY_PRESET)) {
                    String token = this.getXpp().getAttributeValue(null, ATTR_TOKEN);
                    onvifPreset.setToken(token);
                    this.getXpp().nextTag();
                    if (this.getXpp().getName().equals(ATTR_NAME)) {
                        this.getXpp().next();
                        String name = this.getXpp().getText();
                        onvifPreset.setName(name);
                        this.getXpp().nextTag();
                    }
                    this.getXpp().nextTag();
                    if (this.getXpp().getName().equals(KEY_POSITION)) {
                        this.getXpp().nextTag();
                        if (this.getXpp().getName().equals(KEY_POSITION_PANTILT)) {
                            onvifPreset.setPan(Double.valueOf(this.getXpp().getAttributeValue(null, "x")));
                            onvifPreset.setTilt(Double.valueOf(this.getXpp().getAttributeValue(null, "y")));
                            this.getXpp().nextTag();
                        }
                        this.getXpp().nextTag();
                        if (this.getXpp().getName().equals(KEY_POSITION_ZOOM)) {
                            onvifPreset.setZoom(Double.valueOf(this.getXpp().getAttributeValue(null, "x")));
                        }
                        this.getXpp().nextTag();
                    }
                    presets.add(onvifPreset);
                }
                this.eventType = this.getXpp().next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
        return presets;
    }
}

