/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.requests;

import be.teletask.onvif.listeners.OnvifResponseListener;
import be.teletask.onvif.models.OnvifMediaProfile;
import be.teletask.onvif.models.OnvifType;
import be.teletask.onvif.requests.OnvifRequest;

public class AbsoluteMoveRequest
implements OnvifRequest {
    public static final String TAG = AbsoluteMoveRequest.class.getSimpleName();
    private OnvifResponseListener listener;
    private OnvifMediaProfile mediaProfile;
    private double pan = 0.0;
    private double tilt = 0.0;
    private double zoom = 0.0;

    public AbsoluteMoveRequest(OnvifMediaProfile mediaProfile, double pan, double tilt, double zoom) {
        this.mediaProfile = mediaProfile;
        this.pan = pan;
        this.tilt = tilt;
        this.zoom = zoom;
    }

    public AbsoluteMoveRequest(OnvifMediaProfile mediaProfile, double pan, double tilt, double zoom, OnvifResponseListener listener) {
        this.mediaProfile = mediaProfile;
        this.pan = pan;
        this.tilt = tilt;
        this.zoom = zoom;
        this.listener = listener;
    }

    @Override
    public String getXml() {
        return "<AbsoluteMove xmlns=\"http://www.onvif.org/ver20/ptz/wsdl\"><ProfileToken>" + this.mediaProfile.getToken() + "</ProfileToken><Position> <PanTilt x=\"" + this.pan + "\" y=\"" + this.tilt + "\" xmlns=\"http://www.onvif.org/ver10/schema\" /><Zoom x=\"" + this.zoom + "\" xmlns=\"http://www.onvif.org/ver10/schema\" /></Position></AbsoluteMove>";
    }

    @Override
    public OnvifType getType() {
        return OnvifType.ABSOLUTE_MOVE;
    }

    public OnvifResponseListener getListener() {
        return this.listener;
    }

    public OnvifMediaProfile getMediaProfile() {
        return this.mediaProfile;
    }

    public double getPan() {
        return this.pan;
    }

    public double getTilt() {
        return this.tilt;
    }

    public double getZoom() {
        return this.zoom;
    }

    public AbsoluteMoveRequest() {
    }
}

