/*
 * Decompiled with CFR 0.152.
 */
package be.teletask.onvif.requests;

import be.teletask.onvif.listeners.OnvifPresetListener;
import be.teletask.onvif.models.OnvifMediaProfile;
import be.teletask.onvif.models.OnvifType;
import be.teletask.onvif.requests.OnvifRequest;

public class SetPresetRequest
implements OnvifRequest {
    public static final String TAG = SetPresetRequest.class.getSimpleName();
    private OnvifPresetListener listener;
    private OnvifMediaProfile mediaProfile;
    private String name = "";
    private String token = "";
    private StringBuilder sb = new StringBuilder();

    public SetPresetRequest(OnvifMediaProfile mediaProfile, String name, String token, OnvifPresetListener listener) {
        this.mediaProfile = mediaProfile;
        this.name = name;
        this.token = token;
        this.listener = listener;
    }

    @Override
    public String getXml() {
        this.sb.setLength(0);
        this.sb.append("<SetPreset xmlns=\"http://www.onvif.org/ver20/ptz/wsdl\">");
        this.sb.append("<ProfileToken>" + this.mediaProfile.getToken() + "</ProfileToken>");
        if (this.name != null && !this.name.isEmpty()) {
            this.sb.append("<PresetName>" + this.name + "</PresetName>");
        }
        if (this.token != null && !this.token.isEmpty()) {
            this.sb.append("<PresetToken>" + this.token + "</PresetToken>");
        }
        this.sb.append("</SetPreset>");
        return this.sb.toString();
    }

    @Override
    public OnvifType getType() {
        return OnvifType.SET_PRESET;
    }

    public OnvifPresetListener getListener() {
        return this.listener;
    }

    public OnvifMediaProfile getMediaProfile() {
        return this.mediaProfile;
    }

    public String getName() {
        return this.name;
    }

    public String getToken() {
        return this.token;
    }

    public StringBuilder getSb() {
        return this.sb;
    }

    public SetPresetRequest() {
    }
}

