/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.controller.adapters;

import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.angads25.filepicker.R;
import com.github.angads25.filepicker.controller.NotifyItemChecked;
import com.github.angads25.filepicker.model.DialogProperties;
import com.github.angads25.filepicker.model.FileListItem;
import com.github.angads25.filepicker.model.MarkedItemList;
import com.github.angads25.filepicker.widget.MaterialCheckbox;
import com.github.angads25.filepicker.widget.OnCheckedChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;

public class FileListAdapter
extends BaseAdapter {
    private ArrayList<FileListItem> listItem;
    private Context context;
    private DialogProperties properties;
    private NotifyItemChecked notifyItemChecked;

    public FileListAdapter(ArrayList<FileListItem> listItem, Context context, DialogProperties properties) {
        this.listItem = listItem;
        this.context = context;
        this.properties = properties;
    }

    public int getCount() {
        return this.listItem.size();
    }

    public FileListItem getItem(int i) {
        return this.listItem.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        Animation animation;
        ViewHolder holder;
        if (view == null) {
            view = LayoutInflater.from((Context)this.context).inflate(R.layout.dialog_file_list_item, viewGroup, false);
            holder = new ViewHolder(view);
            view.setTag((Object)holder);
        } else {
            holder = (ViewHolder)view.getTag();
        }
        final FileListItem item = this.listItem.get(i);
        if (MarkedItemList.hasItem(item.getLocation())) {
            animation = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.marked_item_animation);
            view.setAnimation(animation);
        } else {
            animation = AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.unmarked_item_animation);
            view.setAnimation(animation);
        }
        if (item.isDirectory()) {
            holder.type_icon.setImageResource(R.mipmap.ic_type_folder);
            if (Build.VERSION.SDK_INT >= 23) {
                holder.type_icon.setColorFilter(this.context.getResources().getColor(R.color.colorPrimary, this.context.getTheme()));
            } else {
                holder.type_icon.setColorFilter(this.context.getResources().getColor(R.color.colorPrimary));
            }
            if (this.properties.selection_type == 0) {
                holder.fmark.setVisibility(4);
            } else {
                holder.fmark.setVisibility(0);
            }
        } else {
            holder.type_icon.setImageResource(R.mipmap.ic_type_file);
            if (Build.VERSION.SDK_INT >= 23) {
                holder.type_icon.setColorFilter(this.context.getResources().getColor(R.color.colorAccent, this.context.getTheme()));
            } else {
                holder.type_icon.setColorFilter(this.context.getResources().getColor(R.color.colorAccent));
            }
            if (this.properties.selection_type == 1) {
                holder.fmark.setVisibility(4);
            } else {
                holder.fmark.setVisibility(0);
            }
        }
        holder.type_icon.setContentDescription((CharSequence)item.getFilename());
        holder.name.setText((CharSequence)item.getFilename());
        SimpleDateFormat sdate = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        SimpleDateFormat stime = new SimpleDateFormat("hh:mm aa", Locale.getDefault());
        Date date = new Date(item.getTime());
        if (i == 0 && item.getFilename().startsWith(this.context.getString(R.string.label_parent_dir))) {
            holder.type.setText(R.string.label_parent_directory);
        } else {
            holder.type.setText((CharSequence)(this.context.getString(R.string.last_edit) + sdate.format(date) + ", " + stime.format(date)));
        }
        if (holder.fmark.getVisibility() == 0) {
            if (i == 0 && item.getFilename().startsWith(this.context.getString(R.string.label_parent_dir))) {
                holder.fmark.setVisibility(4);
            }
            if (MarkedItemList.hasItem(item.getLocation())) {
                holder.fmark.setChecked(true);
            } else {
                holder.fmark.setChecked(false);
            }
        }
        holder.fmark.setOnCheckedChangedListener(new OnCheckedChangeListener(){

            @Override
            public void onCheckedChanged(MaterialCheckbox checkbox, boolean isChecked) {
                item.setMarked(isChecked);
                if (item.isMarked()) {
                    if (((FileListAdapter)FileListAdapter.this).properties.selection_mode == 1) {
                        MarkedItemList.addSelectedItem(item);
                    } else {
                        MarkedItemList.addSingleFile(item);
                    }
                } else {
                    MarkedItemList.removeSelectedItem(item.getLocation());
                }
                FileListAdapter.this.notifyItemChecked.notifyCheckBoxIsClicked();
            }
        });
        return view;
    }

    public void setNotifyItemCheckedListener(NotifyItemChecked notifyItemChecked) {
        this.notifyItemChecked = notifyItemChecked;
    }

    private class ViewHolder {
        ImageView type_icon;
        TextView name;
        TextView type;
        MaterialCheckbox fmark;

        ViewHolder(View itemView) {
            this.name = (TextView)itemView.findViewById(R.id.fname);
            this.type = (TextView)itemView.findViewById(R.id.ftype);
            this.type_icon = (ImageView)itemView.findViewById(R.id.image_type);
            this.fmark = (MaterialCheckbox)itemView.findViewById(R.id.file_mark);
        }
    }
}

