/*
 * Decompiled with CFR 0.152.
 */
package com.github.angads25.filepicker.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import com.github.angads25.filepicker.R;
import com.github.angads25.filepicker.widget.OnCheckedChangeListener;

public class MaterialCheckbox
extends View {
    private Context context;
    private int minDim;
    private Paint paint;
    private RectF bounds;
    private boolean checked;
    private OnCheckedChangeListener onCheckedChangeListener;
    private Path tick;

    public MaterialCheckbox(Context context) {
        super(context);
        this.initView(context);
    }

    public MaterialCheckbox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MaterialCheckbox(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public void initView(Context context) {
        this.context = context;
        this.checked = false;
        this.tick = new Path();
        this.paint = new Paint();
        this.bounds = new RectF();
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                MaterialCheckbox.this.setChecked(!MaterialCheckbox.this.checked);
                MaterialCheckbox.this.onCheckedChangeListener.onCheckedChanged(MaterialCheckbox.this, MaterialCheckbox.this.isChecked());
            }
        };
        this.setOnClickListener(onClickListener);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isChecked()) {
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.bounds.set((float)(this.minDim / 10), (float)(this.minDim / 10), (float)(this.minDim - this.minDim / 10), (float)(this.minDim - this.minDim / 10));
            if (Build.VERSION.SDK_INT >= 23) {
                this.paint.setColor(this.getResources().getColor(R.color.colorAccent, this.context.getTheme()));
            } else {
                this.paint.setColor(this.getResources().getColor(R.color.colorAccent));
            }
            canvas.drawRoundRect(this.bounds, (float)(this.minDim / 8), (float)(this.minDim / 8), this.paint);
            this.paint.setColor(Color.parseColor((String)"#FFFFFF"));
            this.paint.setStrokeWidth((float)(this.minDim / 10));
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeJoin(Paint.Join.BEVEL);
            canvas.drawPath(this.tick, this.paint);
        } else {
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.bounds.set((float)(this.minDim / 10), (float)(this.minDim / 10), (float)(this.minDim - this.minDim / 10), (float)(this.minDim - this.minDim / 10));
            this.paint.setColor(Color.parseColor((String)"#C1C1C1"));
            canvas.drawRoundRect(this.bounds, (float)(this.minDim / 8), (float)(this.minDim / 8), this.paint);
            this.bounds.set((float)(this.minDim / 5), (float)(this.minDim / 5), (float)(this.minDim - this.minDim / 5), (float)(this.minDim - this.minDim / 5));
            this.paint.setColor(Color.parseColor((String)"#FFFFFF"));
            canvas.drawRect(this.bounds, this.paint);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.getMeasuredHeight();
        int width = this.getMeasuredWidth();
        this.minDim = Math.min(width, height);
        this.bounds.set((float)(this.minDim / 10), (float)(this.minDim / 10), (float)(this.minDim - this.minDim / 10), (float)(this.minDim - this.minDim / 10));
        this.tick.moveTo((float)(this.minDim / 4), (float)(this.minDim / 2));
        this.tick.lineTo((float)this.minDim / 2.5f, (float)(this.minDim - this.minDim / 3));
        this.tick.moveTo((float)this.minDim / 2.75f, (float)this.minDim - (float)this.minDim / 3.25f);
        this.tick.lineTo((float)(this.minDim - this.minDim / 4), (float)(this.minDim / 3));
        this.setMeasuredDimension(width, height);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.invalidate();
    }

    public void setOnCheckedChangedListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
    }
}

