/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopSpuService;
import cn.binarywang.wx.miniapp.bean.shop.WxMaShopSpuInfo;
import cn.binarywang.wx.miniapp.bean.shop.WxMaShopSpuWithoutAuditInfo;
import cn.binarywang.wx.miniapp.bean.shop.request.WxMaShopSpuPageRequest;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopAddSpuResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopBaseResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetSpuListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopGetSpuResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopSpuServiceImpl
implements WxMaShopSpuService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopSpuServiceImpl.class);
    private static final String ERR_CODE = "errcode";
    private final WxMaService wxMaService;

    @Override
    public WxMaShopAddSpuResponse addSpu(WxMaShopSpuInfo spuInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/add", spuInfo);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAddSpuResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAddSpuResponse.class);
    }

    @Override
    public WxMaShopBaseResponse deleteSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/del", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopGetSpuResponse getSpu(Integer productId, String outProductId, Integer needEditSpu) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/get", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId, "need_edit_spu", needEditSpu}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopGetSpuResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopGetSpuResponse.class);
    }

    @Override
    public WxMaShopGetSpuListResponse getSpuList(WxMaShopSpuPageRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/get_list", request);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopGetSpuListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopGetSpuListResponse.class);
    }

    @Override
    public WxMaShopAddSpuResponse updateSpu(WxMaShopSpuInfo spuInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/update", spuInfo);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAddSpuResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAddSpuResponse.class);
    }

    @Override
    public WxMaShopAddSpuResponse updateSpuWithoutAudit(WxMaShopSpuWithoutAuditInfo spuInfo) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/update_without_audit", spuInfo);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopAddSpuResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopAddSpuResponse.class);
    }

    @Override
    public WxMaShopBaseResponse listingSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/listing", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    @Override
    public WxMaShopBaseResponse delistingSpu(Integer productId, String outProductId) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/spu/delisting", GsonHelper.buildJsonObject((Object[])new Object[]{"product_id", productId, "out_product_id", outProductId}));
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get(ERR_CODE).getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopBaseResponse.class);
    }

    public WxMaShopSpuServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

