/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.bean;

import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import cn.binarywang.wx.miniapp.util.crypt.WxMaCryptUtils;
import cn.binarywang.wx.miniapp.util.xml.XStreamTransformer;
import com.google.gson.annotations.SerializedName;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.xml.XStreamCDataConverter;
import org.apache.commons.io.IOUtils;

@XStreamAlias(value="xml")
public class WxMaMessage
implements Serializable {
    private static final long serialVersionUID = -3586245291677274914L;
    @SerializedName(value="Encrypt")
    @XStreamAlias(value="Encrypt")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String encrypt;
    @SerializedName(value="ToUserName")
    @XStreamAlias(value="ToUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String toUser;
    @SerializedName(value="FromUserName")
    @XStreamAlias(value="FromUserName")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String fromUser;
    @SerializedName(value="CreateTime")
    @XStreamAlias(value="CreateTime")
    private Integer createTime;
    @SerializedName(value="MsgType")
    @XStreamAlias(value="MsgType")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgType;
    @SerializedName(value="MsgDataFormat")
    @XStreamAlias(value="MsgDataFormat")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String msgDataFormat;
    @SerializedName(value="Content")
    @XStreamAlias(value="Content")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String content;
    @SerializedName(value="MsgId")
    @XStreamAlias(value="MsgId")
    private Long msgId;
    @SerializedName(value="PicUrl")
    @XStreamAlias(value="PicUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String picUrl;
    @SerializedName(value="MediaId")
    @XStreamAlias(value="MediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String mediaId;
    @SerializedName(value="Event")
    @XStreamAlias(value="Event")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String event;
    @SerializedName(value="Title")
    @XStreamAlias(value="Title")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String title;
    @SerializedName(value="AppId")
    @XStreamAlias(value="AppId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String appId;
    @SerializedName(value="PagePath")
    @XStreamAlias(value="PagePath")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String pagePath;
    @SerializedName(value="ThumbUrl")
    @XStreamAlias(value="ThumbUrl")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String thumbUrl;
    @SerializedName(value="ThumbMediaId")
    @XStreamAlias(value="ThumbMediaId")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String thumbMediaId;
    @SerializedName(value="SessionFrom")
    @XStreamAlias(value="SessionFrom")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String sessionFrom;
    @SerializedName(value="isrisky")
    @XStreamAlias(value="isrisky")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String isRisky;
    @SerializedName(value="extra_info_json")
    @XStreamAlias(value="extra_info_json")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String extraInfoJson;
    @SerializedName(value="appid")
    @XStreamAlias(value="appid")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String appid;
    @SerializedName(value="trace_id")
    @XStreamAlias(value="trace_id")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String traceId;
    @SerializedName(value="status_code")
    @XStreamAlias(value="status_code")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String statusCode;
    @SerializedName(value="Scene")
    @XStreamAlias(value="Scene")
    private Integer scene;
    @SerializedName(value="Query")
    @XStreamAlias(value="Query")
    @XStreamConverter(value=XStreamCDataConverter.class)
    private String query;

    public static WxMaMessage fromXml(String xml) {
        return XStreamTransformer.fromXml(WxMaMessage.class, xml);
    }

    public static WxMaMessage fromXml(InputStream is) {
        return XStreamTransformer.fromXml(WxMaMessage.class, is);
    }

    public static WxMaMessage fromEncryptedXml(String encryptedXml, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        String plainText = new WxMaCryptUtils(wxMaConfig).decrypt(msgSignature, timestamp, nonce, encryptedXml);
        return WxMaMessage.fromXml(plainText);
    }

    public static WxMaMessage fromEncryptedXml(InputStream is, WxMaConfig wxMaConfig, String timestamp, String nonce, String msgSignature) {
        try {
            return WxMaMessage.fromEncryptedXml(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), wxMaConfig, timestamp, nonce, msgSignature);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public static WxMaMessage fromJson(String json) {
        return (WxMaMessage)WxMaGsonBuilder.create().fromJson(json, WxMaMessage.class);
    }

    public static WxMaMessage fromEncryptedJson(String encryptedJson, WxMaConfig config) {
        try {
            WxMaMessage encryptedMessage = WxMaMessage.fromJson(encryptedJson);
            String plainText = new WxMaCryptUtils(config).decrypt(encryptedMessage.getEncrypt());
            return WxMaMessage.fromJson(plainText);
        }
        catch (Exception e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public static WxMaMessage fromEncryptedJson(InputStream inputStream, WxMaConfig config) {
        try {
            return WxMaMessage.fromEncryptedJson(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), config);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    public String toString() {
        return this.toJson();
    }

    public String toJson() {
        return WxMaGsonBuilder.create().toJson((Object)this);
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public String getToUser() {
        return this.toUser;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public Integer getCreateTime() {
        return this.createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getMsgDataFormat() {
        return this.msgDataFormat;
    }

    public String getContent() {
        return this.content;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String getEvent() {
        return this.event;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    public String getSessionFrom() {
        return this.sessionFrom;
    }

    public String getIsRisky() {
        return this.isRisky;
    }

    public String getExtraInfoJson() {
        return this.extraInfoJson;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public Integer getScene() {
        return this.scene;
    }

    public String getQuery() {
        return this.query;
    }

    public void setEncrypt(String encrypt) {
        this.encrypt = encrypt;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setCreateTime(Integer createTime) {
        this.createTime = createTime;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setMsgDataFormat(String msgDataFormat) {
        this.msgDataFormat = msgDataFormat;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    public void setSessionFrom(String sessionFrom) {
        this.sessionFrom = sessionFrom;
    }

    public void setIsRisky(String isRisky) {
        this.isRisky = isRisky;
    }

    public void setExtraInfoJson(String extraInfoJson) {
        this.extraInfoJson = extraInfoJson;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxMaMessage)) {
            return false;
        }
        WxMaMessage other = (WxMaMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$encrypt = this.getEncrypt();
        String other$encrypt = other.getEncrypt();
        if (this$encrypt == null ? other$encrypt != null : !this$encrypt.equals(other$encrypt)) {
            return false;
        }
        String this$toUser = this.getToUser();
        String other$toUser = other.getToUser();
        if (this$toUser == null ? other$toUser != null : !this$toUser.equals(other$toUser)) {
            return false;
        }
        String this$fromUser = this.getFromUser();
        String other$fromUser = other.getFromUser();
        if (this$fromUser == null ? other$fromUser != null : !this$fromUser.equals(other$fromUser)) {
            return false;
        }
        Integer this$createTime = this.getCreateTime();
        Integer other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$msgDataFormat = this.getMsgDataFormat();
        String other$msgDataFormat = other.getMsgDataFormat();
        if (this$msgDataFormat == null ? other$msgDataFormat != null : !this$msgDataFormat.equals(other$msgDataFormat)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Long this$msgId = this.getMsgId();
        Long other$msgId = other.getMsgId();
        if (this$msgId == null ? other$msgId != null : !((Object)this$msgId).equals(other$msgId)) {
            return false;
        }
        String this$picUrl = this.getPicUrl();
        String other$picUrl = other.getPicUrl();
        if (this$picUrl == null ? other$picUrl != null : !this$picUrl.equals(other$picUrl)) {
            return false;
        }
        String this$mediaId = this.getMediaId();
        String other$mediaId = other.getMediaId();
        if (this$mediaId == null ? other$mediaId != null : !this$mediaId.equals(other$mediaId)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$pagePath = this.getPagePath();
        String other$pagePath = other.getPagePath();
        if (this$pagePath == null ? other$pagePath != null : !this$pagePath.equals(other$pagePath)) {
            return false;
        }
        String this$thumbUrl = this.getThumbUrl();
        String other$thumbUrl = other.getThumbUrl();
        if (this$thumbUrl == null ? other$thumbUrl != null : !this$thumbUrl.equals(other$thumbUrl)) {
            return false;
        }
        String this$thumbMediaId = this.getThumbMediaId();
        String other$thumbMediaId = other.getThumbMediaId();
        if (this$thumbMediaId == null ? other$thumbMediaId != null : !this$thumbMediaId.equals(other$thumbMediaId)) {
            return false;
        }
        String this$sessionFrom = this.getSessionFrom();
        String other$sessionFrom = other.getSessionFrom();
        if (this$sessionFrom == null ? other$sessionFrom != null : !this$sessionFrom.equals(other$sessionFrom)) {
            return false;
        }
        String this$isRisky = this.getIsRisky();
        String other$isRisky = other.getIsRisky();
        if (this$isRisky == null ? other$isRisky != null : !this$isRisky.equals(other$isRisky)) {
            return false;
        }
        String this$extraInfoJson = this.getExtraInfoJson();
        String other$extraInfoJson = other.getExtraInfoJson();
        if (this$extraInfoJson == null ? other$extraInfoJson != null : !this$extraInfoJson.equals(other$extraInfoJson)) {
            return false;
        }
        String this$appid = this.getAppId();
        String other$appid = other.getAppId();
        if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
            return false;
        }
        String this$traceId = this.getTraceId();
        String other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        String this$statusCode = this.getStatusCode();
        String other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        Integer this$scene = this.getScene();
        Integer other$scene = other.getScene();
        if (this$scene == null ? other$scene != null : !((Object)this$scene).equals(other$scene)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxMaMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $encrypt = this.getEncrypt();
        result = result * 59 + ($encrypt == null ? 43 : $encrypt.hashCode());
        String $toUser = this.getToUser();
        result = result * 59 + ($toUser == null ? 43 : $toUser.hashCode());
        String $fromUser = this.getFromUser();
        result = result * 59 + ($fromUser == null ? 43 : $fromUser.hashCode());
        Integer $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $msgDataFormat = this.getMsgDataFormat();
        result = result * 59 + ($msgDataFormat == null ? 43 : $msgDataFormat.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Long $msgId = this.getMsgId();
        result = result * 59 + ($msgId == null ? 43 : ((Object)$msgId).hashCode());
        String $picUrl = this.getPicUrl();
        result = result * 59 + ($picUrl == null ? 43 : $picUrl.hashCode());
        String $mediaId = this.getMediaId();
        result = result * 59 + ($mediaId == null ? 43 : $mediaId.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $pagePath = this.getPagePath();
        result = result * 59 + ($pagePath == null ? 43 : $pagePath.hashCode());
        String $thumbUrl = this.getThumbUrl();
        result = result * 59 + ($thumbUrl == null ? 43 : $thumbUrl.hashCode());
        String $thumbMediaId = this.getThumbMediaId();
        result = result * 59 + ($thumbMediaId == null ? 43 : $thumbMediaId.hashCode());
        String $sessionFrom = this.getSessionFrom();
        result = result * 59 + ($sessionFrom == null ? 43 : $sessionFrom.hashCode());
        String $isRisky = this.getIsRisky();
        result = result * 59 + ($isRisky == null ? 43 : $isRisky.hashCode());
        String $extraInfoJson = this.getExtraInfoJson();
        result = result * 59 + ($extraInfoJson == null ? 43 : $extraInfoJson.hashCode());
        String $appid = this.getAppId();
        result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
        String $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        String $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : $statusCode.hashCode());
        Integer $scene = this.getScene();
        result = result * 59 + ($scene == null ? 43 : ((Object)$scene).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }
}

