/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq;

import com.google.common.base.Preconditions;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;

public class NSQConfig {
    private String clientId;
    private String hostname;
    private boolean featureNegotiation = true;
    private Integer heartbeatInterval = null;
    private Integer outputBufferSize = null;
    private Integer outputBufferTimeout = null;
    private boolean tlsV1 = false;
    private Compression compression = Compression.NO_COMPRESSION;
    private Integer deflateLevel = null;
    private Integer sampleRate = null;
    private Optional<Integer> maxInFlight = Optional.empty();
    private String userAgent = null;
    private Integer msgTimeout = null;
    private SslContext sslContext = null;
    private EventLoopGroup eventLoopGroup = null;

    public NSQConfig() {
        try {
            this.clientId = InetAddress.getLocalHost().getHostName();
            this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
            this.userAgent = "JavaNSQClient";
        }
        catch (UnknownHostException e) {
            LogManager.getLogger((Object)this).error("Local host name could not resolved", (Throwable)e);
        }
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isFeatureNegotiation() {
        return this.featureNegotiation;
    }

    public void setFeatureNegotiation(boolean featureNegotiation) {
        this.featureNegotiation = featureNegotiation;
    }

    public Integer getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(Integer heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public Integer getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public NSQConfig setMaxInFlight(int maxInFlight) {
        this.maxInFlight = Optional.of(maxInFlight);
        return this;
    }

    public Optional<Integer> getMaxInFlight() {
        return this.maxInFlight;
    }

    public void setOutputBufferSize(Integer outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    public Integer getOutputBufferTimeout() {
        return this.outputBufferTimeout;
    }

    public void setOutputBufferTimeout(Integer outputBufferTimeout) {
        this.outputBufferTimeout = outputBufferTimeout;
    }

    public boolean isTlsV1() {
        return this.tlsV1;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public Integer getDeflateLevel() {
        return this.deflateLevel;
    }

    public void setDeflateLevel(Integer deflateLevel) {
        this.deflateLevel = deflateLevel;
    }

    public Integer getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Integer sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Integer getMsgTimeout() {
        return this.msgTimeout;
    }

    public void setMsgTimeout(Integer msgTimeout) {
        this.msgTimeout = msgTimeout;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SslContext sslContext) {
        Preconditions.checkNotNull((Object)sslContext);
        this.tlsV1 = true;
        this.sslContext = sslContext;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{\"client_id\":\"" + this.clientId + "\", ");
        buffer.append("\"hostname\":\"" + this.hostname + "\", ");
        buffer.append("\"feature_negotiation\": true, ");
        if (this.getHeartbeatInterval() != null) {
            buffer.append("\"heartbeat_interval\":" + this.getHeartbeatInterval().toString() + ", ");
        }
        if (this.getOutputBufferSize() != null) {
            buffer.append("\"output_buffer_size\":" + this.getOutputBufferSize().toString() + ", ");
        }
        if (this.getOutputBufferTimeout() != null) {
            buffer.append("\"output_buffer_timeout\":" + this.getOutputBufferTimeout().toString() + ", ");
        }
        if (this.isTlsV1()) {
            buffer.append("\"tls_v1\":" + this.isTlsV1() + ", ");
        }
        if (this.getCompression() == Compression.SNAPPY) {
            buffer.append("\"snappy\": true, ");
        }
        if (this.getCompression() == Compression.DEFLATE) {
            buffer.append("\"deflate\": true, ");
        }
        if (this.getDeflateLevel() != null) {
            buffer.append("\"deflate_level\":" + this.getDeflateLevel().toString() + ", ");
        }
        if (this.getSampleRate() != null) {
            buffer.append("\"sample_rate\":" + this.getSampleRate().toString() + ", ");
        }
        if (this.getMsgTimeout() != null) {
            buffer.append("\"msg_timeout\":" + this.getMsgTimeout().toString() + ", ");
        }
        buffer.append("\"user_agent\": \"" + this.userAgent + "\"}");
        return buffer.toString();
    }

    public static enum Compression {
        NO_COMPRESSION,
        DEFLATE,
        SNAPPY;

    }
}

