/*
 * Decompiled with CFR 0.152.
 */
package com.github.brainlag.nsq.lookup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.brainlag.nsq.ServerAddress;
import com.github.brainlag.nsq.lookup.NSQLookup;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

public class DefaultNSQLookup
implements NSQLookup {
    Set<String> addresses = Sets.newHashSet();
    private final ObjectMapper mapper;

    public DefaultNSQLookup() {
        this(new ObjectMapper());
    }

    public DefaultNSQLookup(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public void addLookupAddress(String addr, int port) {
        if (!addr.startsWith("http")) {
            addr = "http://" + addr;
        }
        addr = addr + ":" + port;
        this.addresses.add(addr);
    }

    @Override
    public Set<ServerAddress> lookup(String topic) {
        HashSet addresses = Sets.newHashSet();
        for (String addr : this.getLookupAddresses()) {
            try {
                String topicEncoded = URLEncoder.encode(topic, Charsets.UTF_8.name());
                JsonNode jsonNode = this.mapper.readTree(new URL(addr + "/lookup?topic=" + topicEncoded));
                LogManager.getLogger((Object)this).debug("Server connection information: {}", new Object[]{jsonNode});
                JsonNode producers = jsonNode.findValue("producers");
                for (JsonNode node : producers) {
                    String host = node.get("broadcast_address").asText();
                    ServerAddress address = new ServerAddress(host, node.get("tcp_port").asInt());
                    addresses.add(address);
                }
            }
            catch (IOException e) {
                LogManager.getLogger((Object)this).warn("Unable to connect to address {} for topic {}", new Object[]{addr, topic});
                LogManager.getLogger((Object)this).debug(e.getMessage());
            }
        }
        if (addresses.isEmpty()) {
            LogManager.getLogger((Object)this).warn("Unable to connect to any NSQ Lookup servers, servers tried: {} on topic: {}", new Object[]{this.addresses, topic});
        }
        return addresses;
    }

    public Set<String> getLookupAddresses() {
        return this.addresses;
    }
}

