/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.diagnostics.logging;

import space.fei.code.onvif.assertions.Assertions;
import space.fei.code.onvif.diagnostics.logging.JULLogger;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.SLF4JLogger;
import space.fei.code.onvif.exception.LogException;

public final class Loggers {
    public static final String PREFIX = "space.fei.code";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(Class<?> aClass) {
        if (!aClass.getName().startsWith(PREFIX)) {
            throw new LogException("Error suffix " + aClass.getName());
        }
        return USE_SLF4J ? new SLF4JLogger(aClass) : new JULLogger(aClass.getName());
    }

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (!suffix.startsWith(".") && !suffix.endsWith(".")) {
            String name = "space.fei.code." + suffix;
            return USE_SLF4J ? new SLF4JLogger(name) : new JULLogger(name);
        }
        throw new LogException("The suffix can not start or end with a '.'");
    }

    private Loggers() {
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.Logger");
            return true;
        }
        catch (ClassNotFoundException var1) {
            return false;
        }
    }
}

