/*
 * Decompiled with CFR 0.152.
 */
package space.fei.code.onvif.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import space.fei.code.onvif.diagnostics.logging.Logger;
import space.fei.code.onvif.diagnostics.logging.Loggers;

public class NetworkUtils {
    private static final Logger LOGGER = Loggers.getLogger(NetworkUtils.class);

    public static Map getAllNetAddress() {
        HashMap<String, String> all = new HashMap<String, String>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    all.put(address.getHostAddress(), nif.getName());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        return all;
    }

    public static InetAddress getLocalHostLANAddress() throws UnknownHostException {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            if (candidateAddress != null) {
                return candidateAddress;
            }
            InetAddress jdkSuppliedAddress = InetAddress.getLocalHost();
            if (jdkSuppliedAddress == null) {
                throw new UnknownHostException("The JDK InetAddress.getLocalHost() method unexpectedly returned null.");
            }
            return jdkSuppliedAddress;
        }
        catch (Exception e) {
            UnknownHostException unknownHostException = new UnknownHostException("Failed to determine LAN address: " + e);
            unknownHostException.initCause(e);
            throw unknownHostException;
        }
    }

    public static long getMachineId() {
        try {
            long id;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
            }
            return id;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u673a\u5668ID\u51fa\u9519, " + ExceptionUtils.getStackTrace((Throwable)e));
            return 10080L;
        }
    }

    public static void main(String[] args) throws Exception {
        Map all = NetworkUtils.getAllNetAddress();
        for (Map.Entry entry : all.entrySet()) {
            System.out.println("Key = " + (String)entry.getKey() + ", Value = " + (String)entry.getValue());
        }
        InetAddress address = InetAddress.getLocalHost();
        System.out.println("Local HostAddress: " + address.getHostAddress() + ", Local host name: " + address.getHostName());
        System.out.println("getLocalHostLANAddress:" + NetworkUtils.getLocalHostLANAddress().getHostAddress());
        System.out.println("machineId = " + NetworkUtils.getMachineId());
    }
}

