/*
 * Decompiled with CFR 0.152.
 */
package com.github.dzieciou.testing.curl;

import com.github.dzieciou.testing.curl.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CurlCommand {
    private final List<Header> headers = new ArrayList<Header>();
    private final List<FormPart> formParts = new ArrayList<FormPart>();
    private final List<String> datasBinary = new ArrayList<String>();
    private String url;
    private Optional<String> cookieHeader = Optional.empty();
    private boolean compressed;
    private boolean verbose;
    private boolean insecure;
    private Optional<String> method = Optional.empty();
    private Optional<ServerAuthentication> serverAuthentication = Optional.empty();

    public CurlCommand setUrl(String url) {
        this.url = url;
        return this;
    }

    public CurlCommand addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
        return this;
    }

    public CurlCommand removeHeader(String name) {
        this.headers.removeIf(header -> ((Header)header).name.equals(name));
        return this;
    }

    public CurlCommand addFormPart(String name, String content) {
        this.formParts.add(new FormPart(name, content));
        return this;
    }

    public CurlCommand addDataBinary(String dataBinary) {
        this.datasBinary.add(dataBinary);
        return this;
    }

    public CurlCommand setCookieHeader(String cookieHeader) {
        this.cookieHeader = Optional.of(cookieHeader);
        return this;
    }

    public CurlCommand setCompressed(boolean compressed) {
        this.compressed = compressed;
        return this;
    }

    public CurlCommand setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public CurlCommand setInsecure(boolean insecure) {
        this.insecure = insecure;
        return this;
    }

    public CurlCommand setMethod(String method) {
        this.method = Optional.of(method);
        return this;
    }

    public CurlCommand setServerAuthentication(String user, String password) {
        this.serverAuthentication = Optional.of(new ServerAuthentication(user, password));
        return this;
    }

    public String toString() {
        return this.asString(Platform.RECOGNIZE_AUTOMATICALLY, false, true, true);
    }

    public String asString(Platform targetPlatform, boolean useShortForm, boolean printMultiliner, boolean escapeNonAscii) {
        return new Serializer(targetPlatform, useShortForm, printMultiliner, escapeNonAscii).serialize(this);
    }

    public boolean hasData() {
        return !this.datasBinary.isEmpty();
    }

    private static class Serializer {
        private static final Map<String, String> SHORT_PARAMETER_NAMES = new HashMap<String, String>();
        private final Platform targetPlatform;
        private final boolean useShortForm;
        private final boolean printMultiliner;
        private final boolean escapeNonAscii;

        public Serializer(Platform targetPlatform, boolean useShortForm, boolean printMultiliner, boolean escapeNonAscii) {
            this.targetPlatform = targetPlatform;
            this.useShortForm = useShortForm;
            this.printMultiliner = printMultiliner;
            this.escapeNonAscii = escapeNonAscii;
        }

        private static String parameterName(String longParameterName, boolean useShortForm) {
            return useShortForm ? (SHORT_PARAMETER_NAMES.get(longParameterName) == null ? longParameterName : SHORT_PARAMETER_NAMES.get(longParameterName)) : longParameterName;
        }

        private static List<String> line(boolean useShortForm, String longParameterName, String ... arguments) {
            ArrayList<String> line = new ArrayList<String>(Arrays.asList(arguments));
            line.add(0, Serializer.parameterName(longParameterName, useShortForm));
            return line;
        }

        private static String escapeStringWin(String s) {
            return "\"" + s.replaceAll("\"", "\"\"").replaceAll("%", "\"%\"").replaceAll("\\\\", "\\\\").replaceAll("[\r\n]+", "\"^\r\n$0\"") + "\"";
        }

        private String escapeStringPosix(String s) {
            String escaped = s.chars().mapToObj(c -> this.escape((char)c)).collect(Collectors.joining());
            if (!escaped.equals(s)) {
                return "$'" + escaped + "'";
            }
            return "'" + escaped + "'";
        }

        private String escape(char c) {
            if (Serializer.isAscii(c)) {
                switch (c) {
                    case '\n': {
                        return "\\n";
                    }
                    case '\'': {
                        return "\\'";
                    }
                    case '\t': {
                        return "\\t";
                    }
                    case '\r': {
                        return "\\r";
                    }
                    case '@': {
                        return Serializer.escapeAsHex(c);
                    }
                }
                return Serializer.isAsciiPrintable(c) ? String.valueOf(c) : Serializer.escapeAsHex(c);
            }
            return this.escapeNonAscii ? Serializer.escapeAsHex(c) : String.valueOf(c);
        }

        private static boolean isAscii(char c) {
            return c <= '\u007f';
        }

        private static boolean isAsciiPrintable(char c) {
            return c >= ' ' && c < '\u007f';
        }

        private static String escapeAsHex(char c) {
            char code = c;
            String codeAsHex = Integer.toHexString(code);
            if (code < '\u0100') {
                return code < '\u0010' ? "\\x0" + codeAsHex : "\\x" + codeAsHex;
            }
            return "\\u" + ("" + codeAsHex).substring(codeAsHex.length(), 4);
        }

        public String serialize(CurlCommand curl) {
            ArrayList<List<String>> command = new ArrayList<List<String>>();
            command.add(Serializer.line(this.useShortForm, "curl", this.quoteString(curl.url).replaceAll("[[{}\\\\]]", "\\$&")));
            curl.method.ifPresent(method -> command.add(Serializer.line(this.useShortForm, "--request", method)));
            curl.cookieHeader.ifPresent(cookieHeader -> command.add(Serializer.line(this.useShortForm, "--cookie", this.quoteString((String)cookieHeader))));
            curl.headers.forEach(header -> command.add(Serializer.line(this.useShortForm, "--header", this.quoteString(header.getName() + ": " + header.getValue()))));
            curl.formParts.forEach(formPart -> command.add(Serializer.line(this.useShortForm, "--form", this.quoteString(formPart.getName() + "=" + formPart.getContent()))));
            curl.datasBinary.forEach(data -> command.add(Serializer.line(this.useShortForm, "--data-binary", this.escapeString((String)data))));
            curl.serverAuthentication.ifPresent(sa -> command.add(Serializer.line(this.useShortForm, "--user", this.quoteString(sa.getUser() + ":" + sa.getPassword()))));
            if (curl.compressed) {
                command.add(Serializer.line(this.useShortForm, "--compressed", new String[0]));
            }
            if (curl.insecure) {
                command.add(Serializer.line(this.useShortForm, "--insecure", new String[0]));
            }
            if (curl.verbose) {
                command.add(Serializer.line(this.useShortForm, "--verbose", new String[0]));
            }
            return command.stream().map(line -> line.stream().collect(Collectors.joining(" "))).collect(Collectors.joining(this.chooseJoiningString(this.printMultiliner)));
        }

        private CharSequence chooseJoiningString(boolean printMultiliner) {
            String commandLineSeparator = this.targetPlatform.isOsWindows() ? "^" : "\\";
            return printMultiliner ? String.format(" %s%s  ", commandLineSeparator, this.targetPlatform.lineSeparator()) : " ";
        }

        private String escapeString(String s) {
            return this.targetPlatform.isOsWindows() ? Serializer.escapeStringWin(s) : this.escapeStringPosix(s);
        }

        private String quoteString(String s) {
            return this.targetPlatform.isOsWindows() ? Serializer.quoteStringWin(s) : Serializer.quoteStringPosix(s);
        }

        private static String quoteStringWin(String s) {
            return "\"" + s + "\"";
        }

        private static String quoteStringPosix(String s) {
            return "'" + s + "'";
        }

        static {
            SHORT_PARAMETER_NAMES.put("--user", "-u");
            SHORT_PARAMETER_NAMES.put("--data", "-d");
            SHORT_PARAMETER_NAMES.put("--insecure", "-k");
            SHORT_PARAMETER_NAMES.put("--form", "-F");
            SHORT_PARAMETER_NAMES.put("--cookie", "-b");
            SHORT_PARAMETER_NAMES.put("--header", "-H");
            SHORT_PARAMETER_NAMES.put("--request", "-X");
            SHORT_PARAMETER_NAMES.put("--verbose", "-v");
        }
    }

    public static class ServerAuthentication {
        private final String user;
        private final String password;

        public ServerAuthentication(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public String getUser() {
            return this.user;
        }
    }

    public static class FormPart {
        private final String name;
        private final String content;

        public FormPart(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static class Header {
        private final String name;
        private final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

