/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.spring;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiParam;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import io.swagger.util.ParameterProcessor;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.maven.plugin.logging.Log;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public class SpringSwaggerExtension
extends AbstractSwaggerExtension {
    private static final String DEFAULT_VALUE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";
    private static final RequestParam DEFAULT_REQUEST_PARAM = (RequestParam)MethodUtils.getMatchingMethod(AnnotationBearer.class, (String)"get", (Class[])new Class[]{String.class}).getParameterAnnotations()[0][0];
    private Log log;

    public SpringSwaggerExtension(Log log) {
        this.log = log;
    }

    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        if (annotations.isEmpty()) {
            annotations = Lists.newArrayList((Object[])new Annotation[]{null});
        }
        Map<Class<?>, Annotation> annotationMap = this.toMap(annotations);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.addAll(this.extractParametersFromModelAttributeAnnotation(type, annotationMap));
        parameters.addAll(this.extractParametersFromAnnotation(type, annotationMap));
        if (!parameters.isEmpty()) {
            return parameters;
        }
        return super.extractParameters((List)annotations, type, typesToSkip, chain);
    }

    private Map<Class<?>, Annotation> toMap(Collection<? extends Annotation> annotations) {
        HashMap annotationMap = new HashMap();
        for (Annotation annotation : annotations) {
            if (annotation == null) continue;
            annotationMap.put(annotation.annotationType(), annotation);
        }
        return annotationMap;
    }

    private boolean hasClassStartingWith(Collection<Class<?>> list, String value) {
        for (Class<?> aClass : list) {
            if (!aClass.getName().startsWith(value)) continue;
            return true;
        }
        return false;
    }

    private List<Parameter> extractParametersFromAnnotation(Type type, Map<Class<?>, Annotation> annotations) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (this.isRequestParamType(type, annotations)) {
            parameters.add(this.extractRequestParam(type, (RequestParam)annotations.get(RequestParam.class)));
        }
        if (annotations.containsKey(PathVariable.class)) {
            PathVariable pathVariable = (PathVariable)annotations.get(PathVariable.class);
            PathParameter pathParameter = this.extractPathVariable(type, pathVariable);
            parameters.add((Parameter)pathParameter);
        }
        if (annotations.containsKey(RequestHeader.class)) {
            RequestHeader requestHeader = (RequestHeader)annotations.get(RequestHeader.class);
            HeaderParameter headerParameter = this.extractRequestHeader(type, requestHeader);
            parameters.add((Parameter)headerParameter);
        }
        if (annotations.containsKey(CookieValue.class)) {
            CookieValue cookieValue = (CookieValue)annotations.get(CookieValue.class);
            CookieParameter cookieParameter = this.extractCookieValue(type, cookieValue);
            parameters.add((Parameter)cookieParameter);
        }
        if (annotations.containsKey(RequestPart.class)) {
            RequestPart requestPart = (RequestPart)annotations.get(RequestPart.class);
            FormParameter formParameter = this.extractRequestPart(type, requestPart);
            parameters.add((Parameter)formParameter);
        }
        return parameters;
    }

    private Parameter extractRequestParam(Type type, RequestParam requestParam) {
        Property schema;
        if (requestParam == null) {
            requestParam = DEFAULT_REQUEST_PARAM;
        }
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestParam.value(), (CharSequence)requestParam.name());
        QueryParameter queryParameter = (QueryParameter)((QueryParameter)new QueryParameter().name(paramName)).required(requestParam.required());
        if (!DEFAULT_VALUE.equals(requestParam.defaultValue())) {
            queryParameter.setDefaultValue(requestParam.defaultValue());
            queryParameter.setRequired(false);
        }
        if ((schema = this.readAsPropertyIfPrimitive(type)) != null) {
            queryParameter.setProperty(schema);
        }
        return queryParameter;
    }

    private FormParameter extractRequestPart(Type type, RequestPart requestPart) {
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
        FormParameter formParameter = (FormParameter)((FormParameter)new FormParameter().name(paramName)).required(requestPart.required());
        JavaType ct = this.constructType(type);
        Object schema = MultipartFile.class.isAssignableFrom(ct.getRawClass()) ? new FileProperty() : (ct.isContainerType() && MultipartFile.class.isAssignableFrom(ct.getContentType().getRawClass()) ? new ArrayProperty().items((Property)new FileProperty()) : ModelConverters.getInstance().readAsProperty(type));
        if (schema != null) {
            formParameter.setProperty((Property)schema);
        }
        return formParameter;
    }

    private CookieParameter extractCookieValue(Type type, CookieValue cookieValue) {
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)cookieValue.value(), (CharSequence)cookieValue.name());
        CookieParameter cookieParameter = (CookieParameter)((CookieParameter)new CookieParameter().name(paramName)).required(cookieValue.required());
        Property schema = this.readAsPropertyIfPrimitive(type);
        if (!DEFAULT_VALUE.equals(cookieValue.defaultValue())) {
            cookieParameter.setDefaultValue(cookieValue.defaultValue());
            cookieParameter.setRequired(false);
        }
        if (schema != null) {
            cookieParameter.setProperty(schema);
        }
        return cookieParameter;
    }

    private HeaderParameter extractRequestHeader(Type type, RequestHeader requestHeader) {
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestHeader.value(), (CharSequence)requestHeader.name());
        HeaderParameter headerParameter = (HeaderParameter)((HeaderParameter)new HeaderParameter().name(paramName)).required(requestHeader.required());
        Property schema = this.readAsPropertyIfPrimitive(type);
        if (!DEFAULT_VALUE.equals(requestHeader.defaultValue())) {
            headerParameter.setDefaultValue(requestHeader.defaultValue());
            headerParameter.setRequired(false);
        }
        if (schema != null) {
            headerParameter.setProperty(schema);
        }
        return headerParameter;
    }

    private PathParameter extractPathVariable(Type type, PathVariable pathVariable) {
        String paramName = (String)StringUtils.defaultIfEmpty((CharSequence)pathVariable.value(), (CharSequence)pathVariable.name());
        PathParameter pathParameter = (PathParameter)new PathParameter().name(paramName);
        Property schema = this.readAsPropertyIfPrimitive(type);
        if (schema != null) {
            pathParameter.setProperty(schema);
        }
        return pathParameter;
    }

    private Property readAsPropertyIfPrimitive(Type type) {
        if (com.github.kongchen.swagger.docgen.util.TypeUtils.isPrimitive(type)) {
            return ModelConverters.getInstance().readAsProperty(type);
        }
        String msg = String.format("Can't use non-primitive type: %s as request parameter", type);
        this.log.error((CharSequence)msg);
        JavaType ct = this.constructType(type);
        if (this.isSimpleWrapperForString(ct.getRawClass())) {
            this.log.warn((CharSequence)String.format("Non-primitive type: %s used as string for request parameter", type));
            return new StringProperty();
        }
        return null;
    }

    private boolean isSimpleWrapperForString(Class<?> clazz) {
        try {
            Constructor<?>[] constructors = clazz.getConstructors();
            if (constructors.length <= 2) {
                if (constructors.length == 1) {
                    return clazz.getConstructor(String.class) != null;
                }
                if (constructors.length == 2) {
                    return clazz.getConstructor(String.class) != null && clazz.getConstructor(new Class[0]) != null;
                }
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private List<Parameter> extractParametersFromModelAttributeAnnotation(Type type, Map<Class<?>, Annotation> annotations) {
        ModelAttribute modelAttribute = (ModelAttribute)annotations.get(ModelAttribute.class);
        if ((modelAttribute == null || !this.hasClassStartingWith(annotations.keySet(), "org.springframework.web.bind.annotation")) && BeanUtils.isSimpleProperty((Class)TypeUtils.getRawType((Type)type, null))) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Class clazz = TypeUtils.getRawType((Type)type, (Type)type);
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors((Class)clazz)) {
            Annotation[][] parameterAnnotations;
            ApiParam propertySetterApiParam;
            Method propertyDescriptorSetter = propertyDescriptor.getWriteMethod();
            if (propertyDescriptorSetter == null || (propertySetterApiParam = (ApiParam)AnnotationUtils.findAnnotation((Method)propertyDescriptorSetter, ApiParam.class)) == null || (parameterAnnotations = propertyDescriptorSetter.getParameterAnnotations()) == null || parameterAnnotations.length == 0) continue;
            Class<?> parameterClass = propertyDescriptor.getPropertyType();
            List<Parameter> propertySetterExtractedParameters = this.extractParametersFromAnnotation(parameterClass, this.toMap(Arrays.asList(parameterAnnotations[0])));
            for (Parameter parameter : propertySetterExtractedParameters) {
                if (Strings.isNullOrEmpty((String)parameter.getName())) {
                    parameter.setName(propertyDescriptor.getDisplayName());
                }
                ParameterProcessor.applyAnnotations((Swagger)new Swagger(), (Parameter)parameter, (Type)type, (List)Lists.newArrayList((Object[])new Annotation[]{propertySetterApiParam}));
            }
            parameters.addAll(propertySetterExtractedParameters);
        }
        return parameters;
    }

    private boolean isRequestParamType(Type type, Map<Class<?>, Annotation> annotations) {
        RequestParam requestParam = (RequestParam)annotations.get(RequestParam.class);
        return requestParam != null || BeanUtils.isSimpleProperty((Class)TypeUtils.getRawType((Type)type, (Type)type)) && !this.hasClassStartingWith(annotations.keySet(), "org.springframework.web.bind.annotation");
    }

    public boolean shouldIgnoreType(Type type, Set<Type> typesToSkip) {
        String clazzName;
        Class clazz = TypeUtils.getRawType((Type)type, (Type)type);
        if (clazz == null) {
            return false;
        }
        switch (clazzName = clazz.getName()) {
            case "javax.servlet.ServletRequest": 
            case "javax.servlet.ServletResponse": 
            case "javax.servlet.http.HttpSession": 
            case "javax.servlet.http.PushBuilder": 
            case "java.security.Principal": 
            case "java.io.OutputStream": 
            case "java.io.Writer": {
                return true;
            }
        }
        return clazzName.startsWith("org.springframework") && !"org.springframework.web.multipart.MultipartFile".equals(clazzName);
    }

    private static class AnnotationBearer {
        private AnnotationBearer() {
        }

        public void get(@RequestParam String requestParam) {
        }
    }
}

