/*
 * Decompiled with CFR 0.152.
 */
package com.github.lltyk.rhino17r1.xmlimpl;

import com.github.lltyk.rhino17r1.Context;
import com.github.lltyk.rhino17r1.ScriptRuntime;
import com.github.lltyk.rhino17r1.xmlimpl.XMLObjectImpl;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XmlProcessor {
    private boolean ignoreComments;
    private boolean ignoreProcessingInstructions;
    private boolean ignoreWhitespace;
    private boolean prettyPrint;
    private int prettyIndent;
    private DocumentBuilderFactory dom;
    private TransformerFactory xform;
    private DocumentBuilder documentBuilder;
    private RhinoSAXErrorHandler errorHandler = new RhinoSAXErrorHandler();

    XmlProcessor() {
        this.setDefault();
        this.dom = DocumentBuilderFactory.newInstance();
        this.dom.setNamespaceAware(true);
        this.dom.setIgnoringComments(false);
        this.xform = TransformerFactory.newInstance();
    }

    final void setDefault() {
        this.setIgnoreComments(true);
        this.setIgnoreProcessingInstructions(true);
        this.setIgnoreWhitespace(true);
        this.setPrettyPrinting(true);
        this.setPrettyIndent(2);
    }

    final void setIgnoreComments(boolean b) {
        this.ignoreComments = b;
    }

    final void setIgnoreWhitespace(boolean b) {
        this.ignoreWhitespace = b;
    }

    final void setIgnoreProcessingInstructions(boolean b) {
        this.ignoreProcessingInstructions = b;
    }

    final void setPrettyPrinting(boolean b) {
        this.prettyPrint = b;
    }

    final void setPrettyIndent(int i) {
        this.prettyIndent = i;
    }

    final boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    final boolean isIgnoreProcessingInstructions() {
        return this.ignoreProcessingInstructions;
    }

    final boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    final boolean isPrettyPrinting() {
        return this.prettyPrint;
    }

    final int getPrettyIndent() {
        return this.prettyIndent;
    }

    private String toXmlNewlines(String rv) {
        StringBuffer nl = new StringBuffer();
        for (int i = 0; i < rv.length(); ++i) {
            if (rv.charAt(i) == '\r') {
                if (rv.charAt(i + 1) == '\n') continue;
                nl.append('\n');
                continue;
            }
            nl.append(rv.charAt(i));
        }
        return nl.toString();
    }

    private DocumentBuilderFactory getDomFactory() {
        return this.dom;
    }

    private synchronized DocumentBuilder getDocumentBuilderFromPool() throws ParserConfigurationException {
        DocumentBuilder result;
        if (this.documentBuilder == null) {
            DocumentBuilderFactory factory = this.getDomFactory();
            result = factory.newDocumentBuilder();
        } else {
            result = this.documentBuilder;
            this.documentBuilder = null;
        }
        result.setErrorHandler(this.errorHandler);
        return result;
    }

    private synchronized void returnDocumentBuilderToPool(DocumentBuilder db) {
        if (this.documentBuilder == null) {
            this.documentBuilder = db;
            this.documentBuilder.reset();
        }
    }

    private void addProcessingInstructionsTo(Vector v, Node node) {
        if (node instanceof ProcessingInstruction) {
            v.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(v, node.getChildNodes().item(i));
            }
        }
    }

    private void addCommentsTo(Vector v, Node node) {
        if (node instanceof Comment) {
            v.add(node);
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addProcessingInstructionsTo(v, node.getChildNodes().item(i));
            }
        }
    }

    private void addTextNodesToRemoveAndTrim(Vector toRemove, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            boolean BUG_369394_IS_VALID = false;
            if (!BUG_369394_IS_VALID) {
                text.setData(text.getData().trim());
            } else if (text.getData().trim().length() == 0) {
                text.setData("");
            }
            if (text.getData().length() == 0) {
                toRemove.add(node);
            }
        }
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.addTextNodesToRemoveAndTrim(toRemove, node.getChildNodes().item(i));
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Node toXml(String defaultNamespaceUri, String xml) throws SAXException {
        Node node;
        NodeList rv;
        Document document;
        DocumentBuilder builder = null;
        try {
            Node node22;
            int i;
            Vector v;
            String syntheticXml = "<parent xmlns=\"" + defaultNamespaceUri + "\">" + xml + "</parent>";
            builder = this.getDocumentBuilderFromPool();
            document = builder.parse(new InputSource(new StringReader(syntheticXml)));
            if (this.ignoreProcessingInstructions) {
                v = new Vector();
                this.addProcessingInstructionsTo(v, document);
                for (i = 0; i < v.size(); ++i) {
                    node22 = (Node)v.elementAt(i);
                    node22.getParentNode().removeChild(node22);
                }
            }
            if (this.ignoreComments) {
                v = new Vector();
                this.addCommentsTo(v, document);
                for (i = 0; i < v.size(); ++i) {
                    node22 = (Node)v.elementAt(i);
                    node22.getParentNode().removeChild(node22);
                }
            }
            if (this.ignoreWhitespace) {
                v = new Vector();
                this.addTextNodesToRemoveAndTrim(v, document);
                for (i = 0; i < v.size(); ++i) {
                    node22 = (Node)v.elementAt(i);
                    node22.getParentNode().removeChild(node22);
                }
            }
            if ((rv = document.getDocumentElement().getChildNodes()).getLength() > 1) {
                throw ScriptRuntime.constructError("SyntaxError", "XML objects may contain at most one node.");
            }
            if (rv.getLength() == 0) {
                Text node3;
                node = node3 = document.createTextNode("");
                if (builder != null) {
                    this.returnDocumentBuilderToPool(builder);
                }
                return node;
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Unreachable.");
                catch (ParserConfigurationException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                if (builder != null) {
                    this.returnDocumentBuilderToPool(builder);
                }
                throw throwable;
            }
        }
        {
            Node node4 = rv.item(0);
            document.getDocumentElement().removeChild(node4);
            node = node4;
            if (builder != null) {
                this.returnDocumentBuilderToPool(builder);
            }
            return node;
        }
    }

    Document newDocument() {
        DocumentBuilder builder = null;
        try {
            builder = this.getDocumentBuilderFromPool();
            Document document = builder.newDocument();
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (builder != null) {
                this.returnDocumentBuilderToPool(builder);
            }
        }
    }

    private String toString(Node node) {
        DOMSource source = new DOMSource(node);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            Transformer transformer = this.xform.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
        return this.toXmlNewlines(writer.toString());
    }

    String escapeAttributeValue(Object value) {
        String text = ScriptRuntime.toString(value);
        if (text.length() == 0) {
            return "";
        }
        Document dom = this.newDocument();
        Element e = dom.createElement("a");
        e.setAttribute("b", text);
        String elementText = this.toString(e);
        int begin = elementText.indexOf(34);
        int end = elementText.lastIndexOf(34);
        return elementText.substring(begin + 1, end);
    }

    String escapeTextValue(Object value) {
        if (value instanceof XMLObjectImpl) {
            return ((XMLObjectImpl)value).toXMLString();
        }
        String text = ScriptRuntime.toString(value);
        if (text.length() == 0) {
            return text;
        }
        Document dom = this.newDocument();
        Element e = dom.createElement("a");
        e.setTextContent(text);
        String elementText = this.toString(e);
        int begin = elementText.indexOf(62) + 1;
        int end = elementText.lastIndexOf(60);
        return begin < end ? elementText.substring(begin, end) : "";
    }

    private String escapeElementValue(String s) {
        return this.escapeTextValue(s);
    }

    private String elementToXmlString(Element element) {
        Element copy = (Element)element.cloneNode(true);
        if (this.prettyPrint) {
            this.beautifyElement(copy, 0);
        }
        return this.toString(copy);
    }

    final String ecmaToXmlString(Node node) {
        StringBuffer s = new StringBuffer();
        int indentLevel = 0;
        if (this.prettyPrint) {
            for (int i = 0; i < indentLevel; ++i) {
                s.append(' ');
            }
        }
        if (node instanceof Text) {
            String data = ((Text)node).getData();
            String v = this.prettyPrint ? data.trim() : data;
            s.append(this.escapeElementValue(v));
            return s.toString();
        }
        if (node instanceof Attr) {
            String value = ((Attr)node).getValue();
            s.append(this.escapeAttributeValue(value));
            return s.toString();
        }
        if (node instanceof Comment) {
            s.append("<!--" + ((Comment)node).getNodeValue() + "-->");
            return s.toString();
        }
        if (node instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)node;
            s.append("<?" + pi.getTarget() + " " + pi.getData() + "?>");
            return s.toString();
        }
        s.append(this.elementToXmlString((Element)node));
        return s.toString();
    }

    private void beautifyElement(Element e, int indent) {
        int i;
        int i2;
        StringBuffer s = new StringBuffer();
        s.append('\n');
        for (int i3 = 0; i3 < indent; ++i3) {
            s.append(' ');
        }
        String afterContent = s.toString();
        for (int i4 = 0; i4 < this.prettyIndent; ++i4) {
            s.append(' ');
        }
        String beforeContent = s.toString();
        Vector<Node> toIndent = new Vector<Node>();
        boolean indentChildren = false;
        for (i2 = 0; i2 < e.getChildNodes().getLength(); ++i2) {
            if (i2 == 1) {
                indentChildren = true;
            }
            if (e.getChildNodes().item(i2) instanceof Text) {
                toIndent.add(e.getChildNodes().item(i2));
                continue;
            }
            indentChildren = true;
            toIndent.add(e.getChildNodes().item(i2));
        }
        if (indentChildren) {
            for (i2 = 0; i2 < toIndent.size(); ++i2) {
                e.insertBefore(e.getOwnerDocument().createTextNode(beforeContent), (Node)toIndent.elementAt(i2));
            }
        }
        NodeList nodes = e.getChildNodes();
        Vector<Node> v = new Vector<Node>();
        for (i = 0; i < nodes.getLength(); ++i) {
            if (!(nodes.item(i) instanceof Element)) continue;
            v.add(nodes.item(i));
        }
        for (i = 0; i < v.size(); ++i) {
            this.beautifyElement((Element)v.elementAt(i), indent + this.prettyIndent);
        }
        if (indentChildren) {
            e.appendChild(e.getOwnerDocument().createTextNode(afterContent));
        }
    }

    private static class RhinoSAXErrorHandler
    implements ErrorHandler {
        private RhinoSAXErrorHandler() {
        }

        private void throwError(SAXParseException e) {
            throw ScriptRuntime.constructError("TypeError", e.getMessage(), e.getLineNumber() - 1);
        }

        public void error(SAXParseException e) {
            this.throwError(e);
        }

        public void fatalError(SAXParseException e) {
            this.throwError(e);
        }

        public void warning(SAXParseException e) {
            Context.reportWarning(e.getMessage());
        }
    }
}

