/*
 * Decompiled with CFR 0.152.
 */
package com.github.lwaddicor.springstartupanalysis.web;

import com.github.lwaddicor.springstartupanalysis.StartProgressBeanPostProcessor;
import com.github.lwaddicor.springstartupanalysis.TreeMapModel;
import com.github.lwaddicor.springstartupanalysis.dto.StartTimeSquareDto;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;
import pd.treemap.Rect;
import pd.treemap.TreemapLayout;

@Controller
@ResponseBody
@RequestMapping(value={"/spring-startup"})
public class SpringStartupController {
    private static final int imageWidth = 1200;
    private static final int imageHeight = 800;
    private BufferedImage image;
    private String html;
    @Autowired
    private StartProgressBeanPostProcessor processor;

    private void doConstruct() {
        this.image = new BufferedImage(1200, 800, 13);
        Rect bounds = new Rect(0.0, 0.0, 1200.0, 800.0);
        TreemapLayout algorithm = new TreemapLayout();
        TreeMapModel mapModel = new TreeMapModel(this.processor.getTimesAsArray(), 1200, 800);
        algorithm.layout(mapModel, bounds);
        List<StartTimeSquareDto> items = mapModel.getSquareItems();
        items.sort((a, b) -> (int)(b.getTime() - a.getTime()));
        Graphics2D g2d = this.image.createGraphics();
        for (StartTimeSquareDto square : items) {
            g2d.setColor(Color.white);
            g2d.drawRect(square.getLeft(), square.getTop(), square.getWidth(), square.getHeight());
            g2d.setColor(Color.gray);
            g2d.drawRect(square.getLeft() + 1, square.getTop() + 1, square.getWidth() - 2, square.getHeight() - 2);
        }
        g2d.dispose();
        STGroupFile hello = new STGroupFile("com/github/lwaddicor/springstartupanalysis/web/StartupTemplate.stg", '$', '$');
        ST st = hello.getInstanceOf("t1");
        st.add("items", items);
        st.add("totaltime", (Object)this.processor.getTotalTime());
        this.html = st.render();
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"text/html;charset=UTF-8"})
    public String getHtml() {
        this.doConstruct();
        return this.html;
    }

    @RequestMapping(value={"/img.jpeg"}, method={RequestMethod.GET})
    public void showImage(HttpServletResponse response) throws IOException {
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.image, "jpeg", jpegOutputStream);
        }
        catch (IllegalArgumentException e) {
            response.sendError(404);
        }
        byte[] imgByte = jpegOutputStream.toByteArray();
        response.setContentType("image/jpeg");
        response.setHeader("Cache-Control", "no-store");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Pragma", "no-cache");
        ServletOutputStream responseOutputStream = response.getOutputStream();
        responseOutputStream.write(imgByte);
        responseOutputStream.flush();
        responseOutputStream.close();
    }
}

