/*
 * Decompiled with CFR 0.152.
 */
package pd.treemap;

import pd.treemap.Layout;
import pd.treemap.MapModel;
import pd.treemap.Mappable;
import pd.treemap.Rect;

public class TreemapLayout
implements Layout {
    private int mid = 0;

    @Override
    public void layout(MapModel model, Rect bounds) {
        this.layout(model.getItems(), bounds);
    }

    public void layout(Mappable[] items, Rect bounds) {
        this.layout(this.sortDescending(items), 0, items.length - 1, bounds);
    }

    public Mappable[] sortDescending(Mappable[] items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Mappable[] inputArr = new Mappable[items.length];
        System.arraycopy(items, 0, inputArr, 0, items.length);
        int length = inputArr.length;
        this.quickSortDesc(inputArr, 0, length - 1);
        return inputArr;
    }

    public void layout(Mappable[] items, int start, int end, Rect bounds) {
        if (start > end) {
            return;
        }
        if (start == end) {
            items[start].setBounds(bounds);
        }
        this.mid = start;
        while (this.mid < end) {
            if (this.highestAspect(items, start, this.mid, bounds) > this.highestAspect(items, start, this.mid + 1, bounds)) {
                ++this.mid;
                continue;
            }
            Rect newBounds = this.layoutRow(items, start, this.mid, bounds);
            this.layout(items, this.mid + 1, end, newBounds);
        }
    }

    public double highestAspect(Mappable[] items, int start, int end, Rect bounds) {
        this.layoutRow(items, start, end, bounds);
        double max = Double.MIN_VALUE;
        for (int i = start; i <= end; ++i) {
            if (!(items[i].getBounds().aspectRatio() > max)) continue;
            max = items[i].getBounds().aspectRatio();
        }
        return max;
    }

    public Rect layoutRow(Mappable[] items, int start, int end, Rect bounds) {
        boolean isHorizontal = bounds.w > bounds.h;
        double total = bounds.w * bounds.h;
        double rowSize = TreemapLayout.totalSize(items, start, end);
        double rowRatio = rowSize / total;
        double offset = 0.0;
        for (int i = start; i <= end; ++i) {
            Rect r = new Rect();
            double ratio = items[i].getSize() / rowSize;
            if (isHorizontal) {
                r.x = bounds.x;
                r.w = bounds.w * rowRatio;
                r.y = bounds.y + bounds.h * offset;
                r.h = bounds.h * ratio;
            } else {
                r.x = bounds.x + bounds.w * offset;
                r.w = bounds.w * ratio;
                r.y = bounds.y;
                r.h = bounds.h * rowRatio;
            }
            items[i].setBounds(r);
            offset += ratio;
        }
        if (isHorizontal) {
            return new Rect(bounds.x + bounds.w * rowRatio, bounds.y, bounds.w - bounds.w * rowRatio, bounds.h);
        }
        return new Rect(bounds.x, bounds.y + bounds.h * rowRatio, bounds.w, bounds.h - bounds.h * rowRatio);
    }

    public static double totalSize(Mappable[] items) {
        return TreemapLayout.totalSize(items, 0, items.length - 1);
    }

    public static double totalSize(Mappable[] items, int start, int end) {
        double sum = 0.0;
        for (int i = start; i <= end; ++i) {
            sum += items[i].getSize();
        }
        return sum;
    }

    private void quickSortDesc(Mappable[] inputArr, int lowerIndex, int higherIndex) {
        int i = lowerIndex;
        int j = higherIndex;
        double pivot = inputArr[lowerIndex + (higherIndex - lowerIndex) / 2].getSize();
        while (i <= j) {
            while (inputArr[i].getSize() > pivot) {
                ++i;
            }
            while (inputArr[j].getSize() < pivot) {
                --j;
            }
            if (i > j) continue;
            Mappable temp = inputArr[i];
            inputArr[i] = inputArr[j];
            inputArr[j] = temp;
            ++i;
            --j;
        }
        if (lowerIndex < j) {
            this.quickSortDesc(inputArr, lowerIndex, j);
        }
        if (i < higherIndex) {
            this.quickSortDesc(inputArr, i, higherIndex);
        }
    }
}

