/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes;

import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.IteratedScope;

public class InScopeSnapshotRunner {
    private final IScope scope;

    public InScopeSnapshotRunner(IScope scope) {
        this.scope = scope;
    }

    public static void runInLocalDataSnapshot(IteratedScope scope, ITask task) {
        InScopeSnapshotRunner.runInLocalDataSnapshot(scope.getScope(), task);
    }

    public static void runInLocalDataSnapshot(IScope scope, ITask task) {
        InScopeSnapshotRunner runner = new InScopeSnapshotRunner(scope);
        runner.runInLocalDataSnapshot(task);
    }

    public static <T> T runInLocalDataSnapshot(IScope scope, IFunction<T> task) {
        InScopeSnapshotRunner runner = new InScopeSnapshotRunner(scope);
        return runner.runInLocalDataSnapshot(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runInLocalDataSnapshot(ITask task) {
        this.scope.createDataSnapshot();
        try {
            task.run();
        }
        finally {
            this.scope.discardLastDataSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runInLocalDataSnapshot(IFunction<T> task) {
        this.scope.createDataSnapshot();
        try {
            T t = task.run();
            return t;
        }
        finally {
            this.scope.discardLastDataSnapshot();
        }
    }

    public static interface IFunction<T> {
        public T run();
    }

    public static interface ITask {
        public void run();
    }
}

