/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.scopes.local.StorageWithPlaceholders;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariablesDeclarationsStorage
extends StorageWithPlaceholders<Expression> {
    private Map<String, Expression> variables = new HashMap<String, Expression>();

    public Expression getValue(String name) {
        return this.variables.get(name);
    }

    public void store(AbstractVariableDeclaration node) {
        this.store(node.getVariable().getName(), node.getValue());
    }

    public void storeAll(VariablesDeclarationsStorage otherStorage) {
        for (Map.Entry<String, Expression> entry : otherStorage.variables.entrySet()) {
            this.store(entry.getKey(), entry.getValue());
        }
    }

    public void store(AbstractVariableDeclaration node, Expression replacementValue) {
        this.store(node.getVariable().getName(), replacementValue);
    }

    @Override
    protected void doStore(String name, Expression replacementValue) {
        this.variables.put(name, replacementValue);
    }

    @Override
    protected void doStore(String name, List<Expression> value) {
        throw new IllegalStateException("not implemented method");
    }

    public void storeIfNotPresent(String name, Expression replacementValue) {
        if (!this.contains(name)) {
            this.store(name, replacementValue);
        }
    }

    public void addFilteredVariables(ExpressionFilter filter, VariablesDeclarationsStorage variablesSource) {
        for (Map.Entry<String, Expression> entry : variablesSource.variables.entrySet()) {
            String name = entry.getKey();
            Expression value = entry.getValue();
            this.store(name, filter.apply(value));
        }
    }

    protected boolean contains(String name) {
        return this.variables.containsKey(name);
    }

    public int size() {
        return this.variables.size();
    }

    public void addToPlaceholder(VariablesDeclarationsStorage otherStorage) {
        Map<String, Expression> otherVariables = otherStorage.variables;
        for (Map.Entry<String, Expression> entry : otherVariables.entrySet()) {
            String name = entry.getKey();
            Expression value = entry.getValue();
            if (!this.storedBeforeUnusedPlaceholder(name) || this.contains(name)) continue;
            this.store(name, value);
        }
    }

    @Override
    public VariablesDeclarationsStorage clone() {
        VariablesDeclarationsStorage clone = (VariablesDeclarationsStorage)super.clone();
        clone.variables = new HashMap<String, Expression>(this.variables);
        return clone;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append("\n");
        result.append("Variables: ").append(this.variables);
        return result.toString();
    }
}

