/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.AlreadyExtended;
import com.github.sommeri.less4j.core.compiler.selectors.GeneralComparatorForExtend;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtendsSolver {
    private GeneralComparatorForExtend comparator = new GeneralComparatorForExtend();
    private List<RuleSet> allRulesets = new ArrayList<RuleSet>();
    private List<Selector> inlineExtends = new ArrayList<Selector>();
    private Map<Selector, List<Selector>> allSelectorExtends = new HashMap<Selector, List<Selector>>();

    public void solveExtends(ASTCssNode node) {
        this.collectRulesets(node);
        this.solveInlineExtends();
    }

    private void solveInlineExtends() {
        for (Selector selector : this.inlineExtends) {
            this.solveInlineExtends(selector);
        }
    }

    private void solveInlineExtends(Selector extendingSelector) {
        AlreadyExtended alreadyExtended = new AlreadyExtended();
        alreadyExtended.markAsAlreadyExtended(extendingSelector, (RuleSet)extendingSelector.getParent());
        for (RuleSet ruleSet : this.allRulesets) {
            ArrayList<Selector> selectors = new ArrayList<Selector>(ruleSet.getSelectors());
            for (Selector targetSelector : selectors) {
                if (!this.shouldExtend(extendingSelector, targetSelector) || !this.canExtend(extendingSelector, alreadyExtended, ruleSet)) continue;
                this.doTheExtend(extendingSelector, alreadyExtended, ruleSet, targetSelector);
            }
        }
    }

    private void doTheExtend(Selector extendingSelector, AlreadyExtended alreadyExtended, RuleSet ruleSet, Selector targetSelector) {
        this.performExtend(extendingSelector, ruleSet);
        this.addToThoseWhoExtended(extendingSelector, targetSelector);
        alreadyExtended.markAsAlreadyExtended(extendingSelector, ruleSet);
        ArrayList<Selector> thoseWhoExtendedExtending = new ArrayList<Selector>(this.getThoseWhoExtended(extendingSelector));
        for (Selector extendedExtending : thoseWhoExtendedExtending) {
            if (!this.canExtend(extendedExtending, alreadyExtended, ruleSet)) continue;
            this.doTheExtend(extendedExtending, alreadyExtended, ruleSet, targetSelector);
        }
    }

    private boolean canExtend(Selector extendingSelector, AlreadyExtended alreadyExtended, RuleSet ruleSet) {
        if (alreadyExtended.alreadyExtended(extendingSelector, ruleSet)) {
            return false;
        }
        for (Selector selector : ruleSet.getSelectors()) {
            if (!this.comparator.equals(selector, extendingSelector)) continue;
            return false;
        }
        return true;
    }

    private void performExtend(Selector extendingSelector, RuleSet ruleSet) {
        Selector selectorClone = extendingSelector.clone();
        selectorClone.setParent(ruleSet);
        ruleSet.addSelector(selectorClone);
    }

    private void addToThoseWhoExtended(Selector extendingSelector, Selector targetSelector) {
        List<Selector> tied = this.getThoseWhoExtended(targetSelector);
        tied.add(extendingSelector);
    }

    private List<Selector> getThoseWhoExtended(Selector selector) {
        List<Selector> result = this.allSelectorExtends.get(selector);
        if (result == null) {
            result = new ArrayList<Selector>();
            this.allSelectorExtends.put(selector, result);
        }
        return result;
    }

    private boolean shouldExtend(Selector extending, Selector possibleTarget) {
        if (possibleTarget == extending) {
            return false;
        }
        List<Extend> extendds = extending.getExtend();
        for (Extend extend : extendds) {
            if (!this.comparator.equals(possibleTarget, extend.getTarget())) continue;
            return true;
        }
        return false;
    }

    private void collectRulesets(ASTCssNode node) {
        switch (node.getType()) {
            case RULE_SET: {
                RuleSet ruleset = (RuleSet)node;
                this.allRulesets.add(ruleset);
                this.collectAllSelectors(ruleset);
                break;
            }
            default: {
                ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
                for (ASTCssNode aSTCssNode : childs) {
                    this.collectRulesets(aSTCssNode);
                }
            }
        }
    }

    private void collectAllSelectors(RuleSet ruleset) {
        for (Selector selector : ruleset.getSelectors()) {
            if (!selector.isExtending()) continue;
            this.inlineExtends.add(selector);
        }
    }
}

