/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.http.Request;
import java.net.URI;
import wiremock.com.google.common.base.Joiner;
import wiremock.com.google.common.base.Splitter;
import wiremock.com.google.common.collect.FluentIterable;
import wiremock.com.google.common.collect.Iterables;

public class UniqueFilenameGenerator {
    public static String generate(Request request, String prefix, String id) {
        URI uri = URI.create(request.getUrl());
        Iterable<String> uriPathNodes = Splitter.on("/").omitEmptyStrings().split(uri.getPath());
        int nodeCount = Iterables.size(uriPathNodes);
        String pathPart = nodeCount > 0 ? Joiner.on("-").join(FluentIterable.from(uriPathNodes).skip(nodeCount - Math.min(nodeCount, 2))) : "(root)";
        return prefix + "-" + pathPart + "-" + id + ".json";
    }
}

