/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockRule
extends WireMockServer
implements MethodRule,
TestRule {
    public WireMockRule(Options options) {
        super(options);
    }

    public WireMockRule(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockRule(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockRule() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public Statement apply(Statement base, Description description) {
        return this.apply(base, null, null);
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                WireMockRule.this.start();
                WireMock.configureFor("localhost", WireMockRule.this.port());
                try {
                    WireMockRule.this.before();
                    base.evaluate();
                }
                finally {
                    WireMockRule.this.after();
                    WireMockRule.this.stop();
                }
            }
        };
    }

    protected void before() {
    }

    protected void after() {
    }
}

