/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal;

public class JsonFormatter {
    private static final String INDENT = "   ";
    private static final String NEW_LINE = System.getProperty("line.separator");

    private static void appendIndent(StringBuilder sb, int count) {
        while (count > 0) {
            sb.append(INDENT);
            --count;
        }
    }

    private static boolean isEscaped(StringBuilder sb, int index) {
        boolean escaped = false;
        while (index > 0 && sb.charAt(--index) == '\\') {
            escaped = !escaped;
        }
        return escaped;
    }

    public static String prettyPrint(String input) {
        StringBuilder output = new StringBuilder(input.length() * 2);
        boolean quoteOpened = false;
        int depth = 0;
        block7: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case '[': 
                case '{': {
                    output.append(ch);
                    if (quoteOpened) continue block7;
                    output.append(NEW_LINE);
                    JsonFormatter.appendIndent(output, ++depth);
                    continue block7;
                }
                case ']': 
                case '}': {
                    if (quoteOpened) {
                        output.append(ch);
                        continue block7;
                    }
                    output.append(NEW_LINE);
                    JsonFormatter.appendIndent(output, --depth);
                    output.append(ch);
                    continue block7;
                }
                case '\"': 
                case '\'': {
                    output.append(ch);
                    if (quoteOpened) {
                        if (JsonFormatter.isEscaped(output, i)) continue block7;
                        quoteOpened = false;
                        continue block7;
                    }
                    quoteOpened = true;
                    continue block7;
                }
                case ',': {
                    output.append(ch);
                    if (quoteOpened) continue block7;
                    output.append(NEW_LINE);
                    JsonFormatter.appendIndent(output, depth);
                    continue block7;
                }
                case ':': {
                    if (quoteOpened) {
                        output.append(ch);
                        continue block7;
                    }
                    output.append(" : ");
                    continue block7;
                }
                default: {
                    if (!quoteOpened && ch == ' ') continue block7;
                    output.append(ch);
                }
            }
        }
        return output.toString();
    }
}

