/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.impl.auth;

import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.auth.AuthScheme;
import wiremock.org.apache.http.auth.AuthSchemeFactory;
import wiremock.org.apache.http.auth.AuthSchemeProvider;
import wiremock.org.apache.http.impl.auth.SPNegoScheme;
import wiremock.org.apache.http.params.HttpParams;
import wiremock.org.apache.http.protocol.HttpContext;

@Immutable
public class SPNegoSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public SPNegoSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public SPNegoSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public SPNegoSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new SPNegoScheme(this.stripPort, this.useCanonicalHostname);
    }
}

