/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.skyscreamer.jsonassert;

public enum JSONCompareMode {
    STRICT(false, true),
    LENIENT(true, false),
    NON_EXTENSIBLE(false, false),
    STRICT_ORDER(true, true);

    private final boolean _extensible;
    private final boolean _strictOrder;

    private JSONCompareMode(boolean extensible, boolean strictOrder) {
        this._extensible = extensible;
        this._strictOrder = strictOrder;
    }

    public boolean isExtensible() {
        return this._extensible;
    }

    public boolean hasStrictOrder() {
        return this._strictOrder;
    }

    public JSONCompareMode withStrictOrdering(boolean strictOrdering) {
        if (strictOrdering) {
            return this.isExtensible() ? STRICT_ORDER : STRICT;
        }
        return this.isExtensible() ? LENIENT : NON_EXTENSIBLE;
    }

    public JSONCompareMode withExtensible(boolean extensible) {
        if (extensible) {
            return this.hasStrictOrder() ? STRICT_ORDER : LENIENT;
        }
        return this.hasStrictOrder() ? STRICT : NON_EXTENSIBLE;
    }
}

