/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http.multipart;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;

public class FileItemPartAdapter
implements Request.Part {
    private final FileItem fileItem;
    public static final Function<FileItem, Request.Part> TO_PARTS = FileItemPartAdapter::new;

    public FileItemPartAdapter(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    @Override
    public String getName() {
        return this.fileItem.getFieldName();
    }

    @Override
    public HttpHeader getHeader(String name) {
        Iterator headerValues = this.fileItem.getHeaders().getHeaders(name);
        return new HttpHeader(name, (String[])Iterators.toArray((Iterator)headerValues, String.class));
    }

    @Override
    public HttpHeaders getHeaders() {
        FileItemHeaders headers = this.fileItem.getHeaders();
        Iterator i = headers.getHeaderNames();
        ImmutableList.Builder builder = ImmutableList.builder();
        while (i.hasNext()) {
            String name = (String)i.next();
            builder.add((Object)this.getHeader(name));
        }
        return new HttpHeaders((Iterable<HttpHeader>)builder.build());
    }

    @Override
    public Body getBody() {
        return new Body(this.fileItem.get());
    }
}

