/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.encryptor.SimpleGCMConfig;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.jasypt.encryption.ByteEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.salt.SaltGenerator;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;

public class SimpleGCMByteEncryptor
implements ByteEncryptor {
    public static final int AES_KEY_SIZE = 256;
    public static final int AES_KEY_PASSWORD_SALT_LENGTH = 16;
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 128;
    private final Singleton<SecretKey> key;
    private final String algorithm;
    private final Singleton<IvGenerator> ivGenerator;

    public byte[] encrypt(byte[] message) {
        byte[] iv = this.ivGenerator.get().generateIv(12);
        Cipher cipher = Cipher.getInstance(this.algorithm);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(1, (Key)this.key.get(), gcmParameterSpec);
        byte[] cipherText = cipher.doFinal(message);
        ByteBuffer byteBuffer = ByteBuffer.allocate(12 + cipherText.length);
        byteBuffer.put(iv);
        byteBuffer.put(cipherText);
        return byteBuffer.array();
    }

    public byte[] decrypt(byte[] encryptedMessage) {
        Cipher cipher = Cipher.getInstance(this.algorithm);
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, encryptedMessage, 0, 12);
        cipher.init(2, (Key)this.key.get(), gcmParameterSpec);
        return cipher.doFinal(encryptedMessage, 12, encryptedMessage.length - 12);
    }

    private SecretKey loadSecretKey(SimpleGCMConfig config) {
        if (config.getActualKey() != null) {
            return config.getActualKey();
        }
        if (config.getSecretKeyPassword() != null) {
            Assert.notNull((Object)config.getSecretKeySaltGenerator(), (String)"Secret key Salt must be provided with password");
            Assert.notNull((Object)config.getSecretKeyAlgorithm(), (String)"Secret key algorithm must be provided with password");
            return SimpleGCMByteEncryptor.getAESKeyFromPassword(config.getSecretKeyPasswordChars(), config.getSecretKeySaltGenerator(), config.getSecretKeyIterations(), config.getSecretKeyAlgorithm());
        }
        Assert.state((config.getSecretKey() != null || config.getSecretKeyResource() != null || config.getSecretKeyLocation() != null ? 1 : 0) != 0, (String)"No key provided");
        return this.loadSecretKeyFromResource(config.loadSecretKeyResource());
    }

    private byte[] getResourceBytes(Resource resource) {
        return FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
    }

    private SecretKey loadSecretKeyFromResource(Resource resource) {
        byte[] secretKeyBytes = Base64.getDecoder().decode(this.getResourceBytes(resource));
        return new SecretKeySpec(secretKeyBytes, "AES");
    }

    public static SecretKey generateSecretKey() {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        SecureRandom random = SecureRandom.getInstanceStrong();
        keyGenerator.init(256, random);
        return keyGenerator.generateKey();
    }

    public static String generateBase64EncodedSecretKey() {
        SecretKey key = SimpleGCMByteEncryptor.generateSecretKey();
        byte[] secretKeyBytes = key.getEncoded();
        return Base64.getEncoder().encodeToString(secretKeyBytes);
    }

    public static SecretKey getAESKeyFromPassword(char[] password, SaltGenerator saltGenerator, int iterations, String algorithm) {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        PBEKeySpec spec = new PBEKeySpec(password, saltGenerator.generateSalt(16), iterations, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    public SimpleGCMByteEncryptor(SimpleGCMConfig config) {
        this.key = Singleton.from(this::loadSecretKey, config);
        this.ivGenerator = Singleton.from(config::getActualIvGenerator);
        this.algorithm = config.getAlgorithm();
    }
}

