/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.encryptor;

import com.ulisesbocchio.jasyptspringboot.configuration.StringEncryptorBuilder;
import com.ulisesbocchio.jasyptspringboot.properties.JasyptEncryptorConfigurationProperties;
import com.ulisesbocchio.jasyptspringboot.util.Functional;
import com.ulisesbocchio.jasyptspringboot.util.Singleton;
import java.util.Optional;
import org.jasypt.encryption.StringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class DefaultLazyEncryptor
implements StringEncryptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultLazyEncryptor.class);
    private final Singleton<StringEncryptor> singleton;

    public DefaultLazyEncryptor(ConfigurableEnvironment e, String customEncryptorBeanName, boolean isCustom, BeanFactory bf) {
        this.singleton = new Singleton<StringEncryptor>(() -> Optional.of(customEncryptorBeanName).filter(arg_0 -> ((BeanFactory)bf).containsBean(arg_0)).map(name -> (StringEncryptor)bf.getBean(name)).map(Functional.tap(bean -> log.info("Found Custom Encryptor Bean {} with name: {}", bean, (Object)customEncryptorBeanName))).orElseGet(() -> {
            if (isCustom) {
                throw new IllegalStateException(String.format("String Encryptor custom Bean not found with name '%s'", customEncryptorBeanName));
            }
            log.info("String Encryptor custom Bean not found with name '{}'. Initializing Default String Encryptor", (Object)customEncryptorBeanName);
            return this.createDefault(e);
        }));
    }

    public DefaultLazyEncryptor(ConfigurableEnvironment e) {
        this.singleton = new Singleton<StringEncryptor>(() -> this.createDefault(e));
    }

    private StringEncryptor createDefault(ConfigurableEnvironment e) {
        return new StringEncryptorBuilder(JasyptEncryptorConfigurationProperties.bindConfigProps(e), "jasypt.encryptor").build();
    }

    public String encrypt(String message) {
        return this.singleton.get().encrypt(message);
    }

    public String decrypt(String encryptedMessage) {
        return this.singleton.get().decrypt(encryptedMessage);
    }
}

