/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.spring.util;

import com.github.xiaoymin.knife4j.annotations.DynamicParameter;
import com.github.xiaoymin.knife4j.annotations.DynamicResponseParameters;
import com.github.xiaoymin.knife4j.core.model.DynamicClass;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteUtils {
    static Logger logger = LoggerFactory.getLogger(ByteUtils.class);
    static final ClassPool classPool = ClassPool.getDefault();

    public static Class<?> loadDynamicClassType(String name) {
        String clazzName = "com.github.xiaoymin.knife4j.model." + name;
        Class<?> dynamicClass = null;
        try {
            dynamicClass = ByteUtils.load(clazzName);
            if (dynamicClass == null) {
                dynamicClass = Class.forName(clazzName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dynamicClass;
    }

    public static Class<?> createDynamicModelClass(String name, DynamicParameter[] parameters) {
        String clazzName = "com.github.xiaoymin.knife4j.model." + name;
        try {
            CtClass tmp = classPool.getCtClass(clazzName);
            if (tmp != null) {
                tmp.detach();
            }
        }
        catch (NotFoundException tmp) {
            // empty catch block
        }
        CtClass ctClass = classPool.makeClass(clazzName);
        try {
            int fieldCount = 0;
            for (DynamicParameter dynamicParameter : parameters) {
                if (dynamicParameter.name() == null || "".equals(dynamicParameter.name()) || "null".equals(dynamicParameter.name())) continue;
                ctClass.addField(ByteUtils.createField(dynamicParameter, ctClass));
                ++fieldCount;
            }
            if (fieldCount > 0) {
                return ctClass.toClass();
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    public static DynamicClass createDynamicModelByOriginalGenericClass(Class<?> originalGenericType, String name, DynamicResponseParameters dynamicResponseParameters) {
        DynamicClass dynamicClass;
        block6: {
            dynamicClass = new DynamicClass();
            try {
                if (originalGenericType == null) break block6;
                String clazzName = "com.github.xiaoymin.knife4j.model." + name;
                try {
                    CtClass tmp = classPool.getCtClass(clazzName);
                    if (tmp != null) {
                        tmp.detach();
                    }
                }
                catch (NotFoundException tmp) {
                    // empty catch block
                }
                CtClass ctClass = classPool.makeClass(clazzName);
                Field[] originalFields = originalGenericType.getDeclaredFields();
                String genericFieldName = "";
                String fieldClassName = name + genericFieldName;
                for (Field field : originalFields) {
                    if (field.getName().equals(genericFieldName)) continue;
                    ctClass.addField(ByteUtils.createByOriginalField(field, ctClass));
                }
                dynamicClass.setTargetClazz(ctClass.toClass());
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        return dynamicClass;
    }

    private static CtField createByDynamicField(Field field, String fieldClassName, DynamicResponseParameters dynamicResponseParameters, CtClass ctClass, DynamicClass dynamicClass) throws CannotCompileException {
        Class<?> fieldClazz = ByteUtils.createDynamicModelClass(fieldClassName, dynamicResponseParameters.properties());
        dynamicClass.setFieldClazz(fieldClazz);
        CtField ctField = new CtField(ByteUtils.getFieldType(fieldClazz), field.getName(), ctClass);
        ctField.setModifiers(1);
        ByteUtils.addAnnotation(ctField, field, ctClass);
        return ctField;
    }

    private static CtField createByOriginalField(Field field, CtClass ctClass) throws CannotCompileException {
        CtField ctField = new CtField(ByteUtils.getFieldType(field.getType()), field.getName(), ctClass);
        ctField.setModifiers(1);
        ByteUtils.addAnnotation(ctField, field, ctClass);
        return ctField;
    }

    private static void addAnnotation(CtField target, Field source, CtClass ctClass) {
        if (source.isAnnotationPresent(ApiModelProperty.class)) {
            ApiModelProperty apiModelProperty = source.getAnnotation(ApiModelProperty.class);
            ConstPool constPool = ctClass.getClassFile().getConstPool();
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation ann = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
            ann.addMemberValue("value", (MemberValue)new StringMemberValue(apiModelProperty.value(), constPool));
            ann.addMemberValue("example", (MemberValue)new StringMemberValue(apiModelProperty.example(), constPool));
            ann.addMemberValue("name", (MemberValue)new StringMemberValue(apiModelProperty.name(), constPool));
            ann.addMemberValue("dataType", (MemberValue)new StringMemberValue(apiModelProperty.dataType(), constPool));
            ann.addMemberValue("access", (MemberValue)new StringMemberValue(apiModelProperty.access(), constPool));
            ann.addMemberValue("allowableValues", (MemberValue)new StringMemberValue(apiModelProperty.allowableValues(), constPool));
            ann.addMemberValue("notes", (MemberValue)new StringMemberValue(apiModelProperty.notes(), constPool));
            ann.addMemberValue("reference", (MemberValue)new StringMemberValue(apiModelProperty.reference(), constPool));
            ann.addMemberValue("value", (MemberValue)new BooleanMemberValue(apiModelProperty.readOnly(), constPool));
            ann.addMemberValue("readOnly", (MemberValue)new BooleanMemberValue(apiModelProperty.hidden(), constPool));
            ann.addMemberValue("required", (MemberValue)new BooleanMemberValue(apiModelProperty.required(), constPool));
            attr.addAnnotation(ann);
            target.getFieldInfo().addAttribute((AttributeInfo)attr);
        }
    }

    public static Class<?> load(String classPathName) {
        try {
            return ClassPool.getDefault().getClassLoader().loadClass(classPathName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static CtField createField(DynamicParameter parameter, CtClass ctClass) throws NotFoundException, CannotCompileException {
        CtField field = new CtField(ByteUtils.getFieldType(parameter.dataTypeClass()), parameter.name(), ctClass);
        field.setModifiers(1);
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation ann = new Annotation("io.swagger.annotations.ApiModelProperty", constPool);
        ann.addMemberValue("value", (MemberValue)new StringMemberValue(parameter.value(), constPool));
        ann.addMemberValue("required", (MemberValue)new BooleanMemberValue(parameter.required(), constPool));
        if (parameter.example() != null && !"".equals(parameter.example())) {
            ann.addMemberValue("example", (MemberValue)new StringMemberValue(parameter.example(), constPool));
        }
        attr.addAnnotation(ann);
        field.getFieldInfo().addAttribute((AttributeInfo)attr);
        return field;
    }

    public static CtClass getFieldType(Class<?> propetyType) {
        CtClass fieldType = null;
        try {
            fieldType = !propetyType.isAssignableFrom(Void.class) ? classPool.get(propetyType.getName()) : classPool.get(String.class.getName());
        }
        catch (NotFoundException e) {
            ClassClassPath path = new ClassClassPath(propetyType);
            classPool.insertClassPath((ClassPath)path);
            try {
                fieldType = classPool.get(propetyType.getName());
            }
            catch (NotFoundException e1) {
                logger.error(e1.getMessage(), (Throwable)e1);
            }
        }
        return fieldType;
    }
}

