/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.admin.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SnapshotName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}/clusters/{cluster}/snapshots/{snapshot}");
    private final String project;
    private final String instance;
    private final String cluster;
    private final String snapshot;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SnapshotName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.cluster = (String)Preconditions.checkNotNull((Object)builder.getCluster());
        this.snapshot = (String)Preconditions.checkNotNull((Object)builder.getSnapshot());
    }

    public static SnapshotName of(String project, String instance, String cluster, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setSnapshot(snapshot).build();
    }

    public static String format(String project, String instance, String cluster, String snapshot) {
        return SnapshotName.newBuilder().setProject(project).setInstance(instance).setCluster(cluster).setSnapshot(snapshot).build().toString();
    }

    public static SnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SnapshotName.parse: formattedString not in valid format");
        return SnapshotName.of((String)matchMap.get("project"), (String)matchMap.get("instance"), (String)matchMap.get("cluster"), (String)matchMap.get("snapshot"));
    }

    public static List<SnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<SnapshotName> list = new ArrayList<SnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("SnapshotName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance, "cluster", this.cluster, "snapshot", this.snapshot});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SnapshotName) {
            SnapshotName that = (SnapshotName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance) && this.cluster.equals(that.cluster) && this.snapshot.equals(that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.instance.hashCode();
        h *= 1000003;
        h ^= this.cluster.hashCode();
        h *= 1000003;
        return h ^= this.snapshot.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;
        private String cluster;
        private String snapshot;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setCluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder() {
        }

        private Builder(SnapshotName snapshotName) {
            this.project = snapshotName.project;
            this.instance = snapshotName.instance;
            this.cluster = snapshotName.cluster;
            this.snapshot = snapshotName.snapshot;
        }

        public SnapshotName build() {
            return new SnapshotName(this);
        }
    }
}

