
package com.google.cloud.bigtable.data.v2.models;

import com.google.protobuf.ByteString;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_RowCell extends RowCell {

  private final String family;
  private final ByteString qualifier;
  private final long timestamp;
  private final ByteString value;
  private final List<String> labels;

  AutoValue_RowCell(
      String family,
      ByteString qualifier,
      long timestamp,
      ByteString value,
      List<String> labels) {
    if (family == null) {
      throw new NullPointerException("Null family");
    }
    this.family = family;
    if (qualifier == null) {
      throw new NullPointerException("Null qualifier");
    }
    this.qualifier = qualifier;
    this.timestamp = timestamp;
    if (value == null) {
      throw new NullPointerException("Null value");
    }
    this.value = value;
    if (labels == null) {
      throw new NullPointerException("Null labels");
    }
    this.labels = labels;
  }

  @Nonnull
  @Override
  public String family() {
    return family;
  }

  @Nonnull
  @Override
  public ByteString qualifier() {
    return qualifier;
  }

  @Override
  public long timestamp() {
    return timestamp;
  }

  @Nonnull
  @Override
  public ByteString value() {
    return value;
  }

  @Nonnull
  @Override
  public List<String> labels() {
    return labels;
  }

  @Override
  public String toString() {
    return "RowCell{"
        + "family=" + family + ", "
        + "qualifier=" + qualifier + ", "
        + "timestamp=" + timestamp + ", "
        + "value=" + value + ", "
        + "labels=" + labels
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RowCell) {
      RowCell that = (RowCell) o;
      return (this.family.equals(that.family()))
           && (this.qualifier.equals(that.qualifier()))
           && (this.timestamp == that.timestamp())
           && (this.value.equals(that.value()))
           && (this.labels.equals(that.labels()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.family.hashCode();
    h *= 1000003;
    h ^= this.qualifier.hashCode();
    h *= 1000003;
    h ^= (this.timestamp >>> 32) ^ this.timestamp;
    h *= 1000003;
    h ^= this.value.hashCode();
    h *= 1000003;
    h ^= this.labels.hashCode();
    return h;
  }

}
